/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr.shell;

import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.crsh.jcr.shell.GroovyRepositoryBootstrap;
import org.crsh.shell.AbstractCommandTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJCRCommandTestCase
extends AbstractCommandTestCase {
    public AbstractJCRCommandTestCase() {
    }

    public AbstractJCRCommandTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        GroovyRepositoryBootstrap.getRepository();
        super.setUp();
        this.cleanRoot();
    }

    protected void tearDown() throws Exception {
        if (this.shell != null) {
            File config = new File(Thread.currentThread().getContextClassLoader().getResource("conf/transient/").toURI());
            config.delete();
        }
        super.tearDown();
    }

    private void cleanRoot() throws Exception {
        this.assertLogin();
        Node root = (Node)this.groovyShell.evaluate("session.rootNode");
        root.refresh(false);
        NodeIterator it = root.getNodes();
        while (it.hasNext()) {
            Node n = it.nextNode();
            if (n.getName().equals("jcr:system")) continue;
            this.log.debug("Removed node " + n.getPath());
            n.remove();
        }
        root.getSession().save();
        this.evaluate("ws logout");
    }

    protected final void assertLogin() {
        try {
            File config = new File(Thread.currentThread().getContextClassLoader().getResource("conf/transient/").toURI());
            this.assertOk("repo use org.apache.jackrabbit.repository.conf=repository-in-memory.xml;org.apache.jackrabbit.repository.home=" + config.getAbsolutePath());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.assertOk("ws login -u exo -p exo ws");
    }

    protected final List<String> getStringValues(Property p) throws RepositoryException {
        ArrayList<String> strings = new ArrayList<String>();
        for (Value value : p.getValues()) {
            strings.add(value.getString());
        }
        return strings;
    }
}

