/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import java.util.Iterator;
import javax.jcr.Node;
import org.crsh.jcr.AbstractJCRCommandTestCase;

public class AddNodeTestCase
extends AbstractJCRCommandTestCase {
    public void testAddRelativeNode() throws Exception {
        this.assertLogin();
        this.assertOk("node add foo");
        AddNodeTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('foo');")));
        this.assertOk("cd foo");
        this.assertOk("node add ../bar");
        AddNodeTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('bar');")));
    }

    public void testAddAbsoluteNode() throws Exception {
        this.assertLogin();
        this.assertOk("node add /foo");
        AddNodeTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('foo');")));
        this.assertOk("cd foo");
        this.assertOk("node add /bar");
        AddNodeTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('bar');")));
    }

    public void testAddNodes() throws Exception {
        this.assertLogin();
        this.assertOk("node add foo /foo/bar");
        AddNodeTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('foo');")));
        AddNodeTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('foo/bar');")));
    }

    public void testAddWithNodeType() throws Exception {
        this.assertLogin();
        this.assertOk("node add -t nt:file foo");
        AddNodeTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('foo');")));
        AddNodeTestCase.assertEquals((Object)"nt:file", (Object)this.groovyShell.evaluate("return session.rootNode.getNode('foo').primaryNodeType.name;"));
    }

    public void testProduce() throws Exception {
        this.assertLogin();
        Iterator produced = this.assertOk("node add foo").getProduced().iterator();
        AddNodeTestCase.assertTrue((boolean)produced.hasNext());
        AddNodeTestCase.assertEquals((String)"/foo", (String)((Node)produced.next()).getPath());
        AddNodeTestCase.assertFalse((boolean)produced.hasNext());
    }
}

