/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.crsh.jcr.FileSystem;
import org.crsh.util.Safe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Importer
implements FileSystem {
    private static final Logger log = LoggerFactory.getLogger(Importer.class);
    private final ContentHandler handler;
    private final LinkedList<EndElement> stack;
    private final List<String> prefixes;
    private final DefaultHandler attributesHandler = new DefaultHandler(){

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (Importer.this.stack.isEmpty()) {
                log.debug("Adding prefix mapping " + prefix + " for " + uri);
                Importer.this.handler.startPrefixMapping(prefix, uri);
                Importer.this.prefixes.add(prefix);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            log.debug("Creating element " + qName);
            Importer.this.handler.startElement(uri, localName, qName, attributes);
            Importer.this.stack.addLast(new EndElement(uri, localName, qName));
        }
    };

    public Importer(ContentHandler handler) {
        this.handler = handler;
        this.stack = new LinkedList();
        this.prefixes = new ArrayList<String>();
    }

    public void startDirectory(String directoryName) throws IOException {
    }

    public void file(String fileName, int length, InputStream data) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            parser.parse(data, this.attributesHandler);
        }
        catch (Exception e) {
            Safe.rethrow(IOException.class, (Throwable)e);
        }
    }

    public void endDirectory(String directoryName) throws IOException {
        try {
            EndElement end = this.stack.removeLast();
            this.handler.endElement(end.uri, end.localName, end.qName);
            if (this.stack.isEmpty()) {
                for (String prefix : this.prefixes) {
                    log.debug("Removing prefix mapping " + prefix);
                    this.handler.endPrefixMapping(prefix);
                }
                this.prefixes.clear();
            }
        }
        catch (Exception e) {
            Safe.rethrow(IOException.class, (Throwable)e);
        }
    }

    private static class EndElement {
        private final String uri;
        private final String localName;
        private final String qName;

        private EndElement(String uri, String localName, String qName) {
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
        }
    }
}

