/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr.shell;

import java.util.Iterator;
import javax.jcr.Node;
import org.crsh.jcr.shell.AbstractJCRCommandTestCase;

public class SetPermTestCase
extends AbstractJCRCommandTestCase {
    public void testAddPrivilegeableMixin() throws Exception {
        this.assertLogin();
        Node foo = (Node)this.groovyShell.evaluate("return session.rootNode.addNode('foo');");
        this.assertOk("setperm -i julien /foo");
        SetPermTestCase.assertTrue((boolean)foo.isNodeType("exo:privilegeable"));
    }

    public void testSimplePermission() throws Exception {
        this.assertLogin();
        Node foo = (Node)this.groovyShell.evaluate("return session.rootNode.addNode('foo');");
        this.assertOk("setperm -i julien -a read /foo");
        SetPermTestCase.assertTrue((boolean)this.getStringValues(foo.getProperty("exo:permissions")).contains("julien read"));
        this.assertOk("setperm -i julien -r read /foo");
        SetPermTestCase.assertFalse((boolean)this.getStringValues(foo.getProperty("exo:permissions")).contains("julien read"));
    }

    public void testMultiplePermission() throws Exception {
        this.assertLogin();
        Node foo = (Node)this.groovyShell.evaluate("return session.rootNode.addNode('foo');");
        this.assertOk("setperm -i julien -a read -a add_node /foo");
        SetPermTestCase.assertTrue((boolean)this.getStringValues(foo.getProperty("exo:permissions")).contains("julien read"));
        SetPermTestCase.assertTrue((boolean)this.getStringValues(foo.getProperty("exo:permissions")).contains("julien add_node"));
    }

    public void testConsume() throws Exception {
        this.assertLogin();
        Node foo = (Node)this.groovyShell.evaluate("return session.rootNode.addNode('foo');");
        this.assertOk("produce /foo | setperm -i julien -a read");
        SetPermTestCase.assertTrue((boolean)this.getStringValues(foo.getProperty("exo:permissions")).contains("julien read"));
    }

    public void testProduce() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("return session.rootNode.addNode('foo');");
        Iterator produced = this.assertOk("produce /foo | setperm -i julien -a read").getProduced().iterator();
        SetPermTestCase.assertTrue((boolean)produced.hasNext());
        SetPermTestCase.assertEquals((String)"/foo", (String)((Node)produced.next()).getPath());
        SetPermTestCase.assertFalse((boolean)produced.hasNext());
    }
}

