/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import groovy.lang.Closure;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.beans.IntrospectionException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.crsh.jcr.JCRUtils;
import org.crsh.jcr.PropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeMetaClass
extends MetaClassImpl {
    public static void setup() {
    }

    public NodeMetaClass(MetaClassRegistry registry, Class<? extends Node> theClass) throws IntrospectionException {
        super(registry, theClass);
    }

    public Object invokeMethod(Object object, String name, Object[] args) {
        try {
            return this._invokeMethod(object, name, args);
        }
        catch (RepositoryException e) {
            throw new Error(e);
        }
    }

    private Object _invokeMethod(Object object, String name, Object[] args) throws RepositoryException {
        MetaMethod validMethod;
        Node node = (Node)object;
        if (args != null) {
            if (args.length == 0) {
                if ("iterator".equals(name)) {
                    return node.getNodes();
                }
            } else if (args.length == 1) {
                Object arg = args[0];
                if (arg instanceof String && "getProperty".equals(name)) {
                    String propertyName = (String)arg;
                    return JCRUtils.getProperty(node, propertyName);
                }
                if (arg instanceof Closure) {
                    Closure closure = (Closure)arg;
                    if ("eachProperty".equals(name)) {
                        PropertyIterator properties = node.getProperties();
                        while (properties.hasNext()) {
                            Property n = properties.nextProperty();
                            closure.call(new Object[]{n});
                        }
                        return null;
                    }
                } else if ("getAt".equals(name) && arg instanceof Integer) {
                    NodeIterator it = node.getNodes();
                    long size = it.getSize();
                    long index = ((Integer)arg).intValue();
                    if (index < 0L) {
                        if (index < -size) {
                            throw new ArrayIndexOutOfBoundsException((int)index);
                        }
                        index = size + index;
                    } else if (index >= size) {
                        throw new ArrayIndexOutOfBoundsException((int)index);
                    }
                    it.skip(index);
                    return it.next();
                }
            }
        }
        if ((validMethod = super.getMetaMethod(name, args)) != null) {
            return validMethod.invoke((Object)node, args);
        }
        throw new MissingMethodException(name, Node.class, args);
    }

    public Object getProperty(Object object, String property) {
        try {
            return this._getProperty(object, property);
        }
        catch (RepositoryException e) {
            throw new Error(e);
        }
    }

    private Object _getProperty(Object object, String propertyName) throws RepositoryException {
        Node node = (Node)object;
        MetaProperty metaProperty = super.getMetaProperty(propertyName);
        if (metaProperty != null) {
            return metaProperty.getProperty((Object)node);
        }
        try {
            Property property = node.getProperty(propertyName);
            PropertyType type = PropertyType.fromValue(property.getType());
            return type.getValue(property);
        }
        catch (PathNotFoundException e) {
            try {
                return node.getNode(propertyName);
            }
            catch (PathNotFoundException e2) {
                return null;
            }
        }
    }

    public void setProperty(Object object, String property, Object newValue) {
        try {
            this._setProperty(object, property, newValue);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private void _setProperty(Object object, String propertyName, Object propertyValue) throws RepositoryException {
        Node node = (Node)object;
        if (propertyValue == null) {
            node.setProperty(propertyName, (Value)null);
        } else {
            PropertyType type;
            Property property;
            try {
                property = node.getProperty(propertyName);
                type = PropertyType.fromValue(property.getType());
            }
            catch (PathNotFoundException e) {
                type = PropertyType.fromCanonicalType(propertyValue.getClass());
            }
            property = type != null ? type.set(node, propertyName, propertyValue) : null;
            if (property == null && propertyValue instanceof String) {
                if (propertyValue instanceof String) {
                    node.setProperty(propertyName, (String)propertyValue);
                } else {
                    throw new MissingPropertyException("Property " + propertyName + " does not have a correct type " + propertyValue.getClass().getName());
                }
            }
        }
    }

    static {
        try {
            MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
            Class<?> eXoNode = Thread.currentThread().getContextClassLoader().loadClass("org.exoplatform.services.jcr.impl.core.NodeImpl");
            NodeMetaClass mc2 = new NodeMetaClass(registry, eXoNode);
            mc2.initialize();
            registry.setMetaClass(eXoNode, (MetaClass)mc2);
        }
        catch (Exception e) {
            throw new Error("Coult not integrate node meta class");
        }
    }
}

