/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import org.apache.sshd.server.Command;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandFactory;
import org.crsh.cmdline.IntrospectionException;
import org.crsh.cmdline.matcher.CmdLineException;
import org.crsh.cmdline.matcher.CommandMatch;
import org.crsh.cmdline.matcher.InvocationContext;
import org.crsh.cmdline.matcher.Matcher;
import org.crsh.jcr.SinkCommand;
import org.crsh.jcr.SourceCommand;
import org.crsh.ssh.term.FailCommand;
import org.crsh.ssh.term.scp.CommandPlugin;
import org.crsh.ssh.term.scp.SCPAction;

public class SCPCommandPlugin
extends CommandPlugin {
    public Command createCommand(String command) {
        if (command.startsWith("scp ")) {
            try {
                command = command.substring(4);
                SCPAction action = new SCPAction();
                ClassDescriptor descriptor = CommandFactory.create(SCPAction.class);
                Matcher analyzer = Matcher.createMatcher((String)"main", (ClassDescriptor)descriptor);
                CommandMatch match = analyzer.match(command);
                match.invoke(new InvocationContext(), (Object)action);
                if (Boolean.TRUE.equals(action.isSource())) {
                    return new SourceCommand(action.getTarget(), Boolean.TRUE.equals(action.isRecursive()));
                }
                if (Boolean.TRUE.equals(action.isSink())) {
                    return new SinkCommand(action.getTarget(), Boolean.TRUE.equals(action.isRecursive()));
                }
                return new FailCommand("Cannot execute command " + command);
            }
            catch (CmdLineException e) {
                return new FailCommand("Cannot execute command " + command, (Throwable)e);
            }
            catch (IntrospectionException e) {
                return new FailCommand("Cannot execute command " + command, (Throwable)e);
            }
        }
        return new FailCommand("Cannot execute command " + command);
    }
}

