/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.mail;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.MessagingException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.crsh.TestPluginLifeCycle;
import org.crsh.mail.MailPlugin;
import org.crsh.mail.SmtpSecure;
import org.crsh.mail.StrongTLS;
import org.crsh.mail.Support;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.auth.LoginAuthenticationHandlerFactory;
import org.subethamail.smtp.auth.LoginFailedException;
import org.subethamail.smtp.auth.UsernamePasswordValidator;
import org.subethamail.smtp.server.SMTPServer;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public class MailPluginTestCase
extends TestCase {
    public void testSendPlain() throws Exception {
        Support support = new Support();
        support.doTest();
    }

    public void testSendHtml() throws Exception {
        Support support = new Support(){

            @Override
            protected Future<Boolean> send(MailPlugin plugin) throws IOException, MessagingException {
                return plugin.send(Arrays.asList("dst@gmail.com"), "Testing Subject", (Object)"<html><body>hello wolrd</body></html>", "text/html;charset=UTF-8", new DataSource[0]);
            }
        };
        support.doTest();
    }

    public void testAuth() throws Exception {
        final AtomicReference usernameRef = new AtomicReference();
        final AtomicReference passwordRef = new AtomicReference();
        Support support = new Support(){

            @Override
            protected TestPluginLifeCycle createLifeCycle() throws Exception {
                TestPluginLifeCycle lifeCycle = super.createLifeCycle();
                lifeCycle.setProperty(MailPlugin.SMTP_USERNAME, (Object)"foo");
                lifeCycle.setProperty(MailPlugin.SMTP_PASSWORD, (Object)"bar");
                return lifeCycle;
            }

            @Override
            protected SMTPServer createServer(MessageHandlerFactory mhf) {
                SMTPServer smtpServer = super.createServer(mhf);
                smtpServer.setAuthenticationHandlerFactory((AuthenticationHandlerFactory)new LoginAuthenticationHandlerFactory(new UsernamePasswordValidator(){

                    public void login(String username, String password) throws LoginFailedException {
                        usernameRef.set(username);
                        passwordRef.set(password);
                    }
                }));
                return smtpServer;
            }
        };
        support.doTest();
        MailPluginTestCase.assertEquals((String)"foo", (String)((String)usernameRef.get()));
        MailPluginTestCase.assertEquals((String)"bar", (String)((String)passwordRef.get()));
    }

    public void testAuthFailed() throws Exception {
        final AtomicBoolean done = new AtomicBoolean();
        Support support = new Support(){

            @Override
            protected TestPluginLifeCycle createLifeCycle() throws Exception {
                TestPluginLifeCycle lifeCycle = super.createLifeCycle();
                lifeCycle.setProperty(MailPlugin.SMTP_USERNAME, (Object)"foo");
                lifeCycle.setProperty(MailPlugin.SMTP_PASSWORD, (Object)"bar");
                return lifeCycle;
            }

            @Override
            protected SMTPServer createServer(MessageHandlerFactory mhf) {
                SMTPServer smtpServer = super.createServer(mhf);
                smtpServer.setAuthenticationHandlerFactory((AuthenticationHandlerFactory)new LoginAuthenticationHandlerFactory(new UsernamePasswordValidator(){

                    public void login(String username, String password) throws LoginFailedException {
                        done.set(true);
                        throw new LoginFailedException();
                    }
                }));
                return smtpServer;
            }

            @Override
            protected void assertResponse(Wiser wiser, Future<Boolean> response) throws MessagingException, ExecutionException, InterruptedException {
                Assert.assertFalse((boolean)response.get());
            }
        };
        support.doTest();
        MailPluginTestCase.assertEquals((boolean)true, (boolean)done.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendTLS() throws Exception {
        File keyStore = new File(MailPluginTestCase.class.getResource("keystore.jks").toURI());
        File trustStore = new File(MailPluginTestCase.class.getResource("truststore.jks").toURI());
        Properties oldProps = new Properties(System.getProperties());
        System.setProperty("javax.net.ssl.keyStore", keyStore.getAbsolutePath());
        System.setProperty("javax.net.ssl.trustStore", trustStore.getAbsolutePath());
        System.setProperty("javax.net.ssl.keyStorePassword", "crashub");
        try {
            char[] keyStorePassphrase = "crashub".toCharArray();
            KeyStore ksKeys = KeyStore.getInstance("JKS");
            ksKeys.load(new FileInputStream(keyStore), keyStorePassphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ksKeys, keyStorePassphrase);
            char[] trustStorePassphrase = "crashub".toCharArray();
            KeyStore ksTrust = KeyStore.getInstance("JKS");
            ksTrust.load(new FileInputStream(trustStore), trustStorePassphrase);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ksTrust);
            final SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            Support support = new Support(){

                @Override
                protected SMTPServer createServer(MessageHandlerFactory mhf) {
                    return new SMTPServer(mhf){

                        public SSLSocket createSSLSocket(Socket socket) throws IOException {
                            InetSocketAddress remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
                            SSLSocketFactory sf = sslContext.getSocketFactory();
                            SSLSocket s = (SSLSocket)sf.createSocket(socket, remoteAddress.getHostName(), socket.getPort(), true);
                            s.setUseClientMode(false);
                            s.setEnabledProtocols(StrongTLS.intersection(s.getSupportedProtocols(), StrongTLS.ENABLED_PROTOCOLS));
                            s.setEnabledCipherSuites(StrongTLS.intersection(s.getSupportedCipherSuites(), StrongTLS.ENABLED_CIPHER_SUITES));
                            return s;
                        }
                    };
                }

                @Override
                protected TestPluginLifeCycle createLifeCycle() throws Exception {
                    TestPluginLifeCycle lifeCycle = super.createLifeCycle();
                    lifeCycle.setProperty(MailPlugin.SMTP_SECURE, (Object)SmtpSecure.TLS);
                    return lifeCycle;
                }
            };
            support.doTest();
        }
        finally {
            System.setProperty("javax.net.ssl.keyStore", oldProps.getProperty("javax.net.ssl.keyStore"));
            System.setProperty("javax.net.ssl.trustStore", oldProps.getProperty("javax.net.ssl.trustStore"));
            System.setProperty("javax.net.ssl.keyStorePassword", oldProps.getProperty("javax.net.ssl.keyStorePassword"));
        }
    }

    public void testSendAttachment() throws Exception {
        final File f = new File(MailPluginTestCase.class.getResource("image.png").toURI());
        Support support = new Support(){

            @Override
            protected Future<Boolean> send(MailPlugin plugin) throws IOException, MessagingException {
                return plugin.send(Arrays.asList("dst@gmail.com"), "Testing Subject", "Dear Mail Crawler,\n\n No spam to my email, please!", new DataSource[]{new FileDataSource(f)});
            }

            @Override
            protected void assertMessage(WiserMessage msg) throws MessagingException {
                super.assertMessage(msg);
                String data = new String(msg.getData());
                String match = "name=image.png";
                Assert.assertTrue((String)("Was expecting " + data + " to contain <" + match + ">"), (boolean)data.contains(match));
            }
        };
        support.doTest();
    }
}

