/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import java.util.LinkedList;
import org.crsh.command.ScriptException;
import org.crsh.shell.impl.Token;

class Tokenizer {
    private static final int NORMAL = 0;
    private final CharSequence s;
    private int index;
    private Character c;

    public Tokenizer(CharSequence s) throws NullPointerException {
        if (s == null) {
            throw new NullPointerException();
        }
        this.s = s;
        this.index = 0;
        this.c = this.index < s.length() ? Character.valueOf(s.charAt(this.index++)) : null;
    }

    private void next() {
        this.c = this.index < this.s.length() ? Character.valueOf(this.s.charAt(this.index++)) : null;
    }

    public Token nextToken() {
        while (this.c != null && Character.isWhitespace(this.c.charValue())) {
            this.next();
        }
        if (this.c == null) {
            return Token.EOF;
        }
        switch (this.c.charValue()) {
            case '+': {
                this.next();
                return Token.PLUS;
            }
            case '|': {
                this.next();
                return Token.PIPE;
            }
        }
        return this.parseCommand();
    }

    private Token parseCommand() throws ScriptException {
        LinkedList<String> chunks = new LinkedList<String>();
        StringBuilder chunk = new StringBuilder();
        Character lastQuote = null;
        block5: while (this.c != null) {
            switch (this.c.charValue()) {
                case ' ': {
                    if (lastQuote == null) {
                        if (chunk.length() <= 0) break;
                        chunks.addLast(chunk.toString());
                        chunk.setLength(0);
                        break;
                    }
                    chunk.append(this.c);
                    break;
                }
                case '\"': 
                case '\'': {
                    if (lastQuote == null) {
                        lastQuote = this.c;
                        chunk.append(this.c);
                        break;
                    }
                    if (lastQuote != this.c) {
                        chunk.append(this.c);
                        break;
                    }
                    chunk.append(this.c);
                    lastQuote = null;
                    break;
                }
                case '+': 
                case '|': {
                    if (lastQuote == null) break block5;
                }
                default: {
                    chunk.append(this.c);
                }
            }
            this.next();
        }
        if (chunk.length() > 0) {
            chunks.addLast(chunk.toString());
        }
        if (lastQuote != null) {
            throw new ScriptException("Quote " + lastQuote + " is not closed");
        }
        return new Token.Command(chunks);
    }
}

