/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.crsh.console.ClientOutput;
import org.crsh.console.Console;
import org.crsh.term.CodeType;
import org.crsh.term.Term;
import org.crsh.term.TermAction;
import org.crsh.term.processor.TermProcessor;
import org.crsh.term.processor.TermResponseContext;
import org.crsh.term.spi.TermIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseTerm
implements Term,
Runnable {
    private static final int STATUS_INITIAL = 0;
    private static final int STATUS_OPEN = 1;
    private static final int STATUS_CLOSED = 2;
    private static final int STATUS_WANT_CLOSE = 3;
    private static final int STATUS_CLOSING = 4;
    private final Logger log = LoggerFactory.getLogger(BaseTerm.class);
    private final TermProcessor processor;
    private final AtomicInteger status;
    private final Object lock = new Object();
    private final LinkedList<Awaiter> awaiters = new LinkedList();
    private final LinkedList<CharSequence> history;
    private CharSequence historyBuffer;
    private int historyCursor;
    private String prompt;
    private final TermIO io;
    private final Console console;

    public BaseTerm(TermIO io) {
        this(io, null);
    }

    public BaseTerm(final TermIO io, TermProcessor processor) {
        this.processor = processor;
        this.status = new AtomicInteger(0);
        this.history = new LinkedList();
        this.historyBuffer = null;
        this.historyCursor = -1;
        this.io = io;
        this.console = new Console(new ClientOutput(){

            protected void flush() throws IOException {
                io.flush();
            }

            protected void writeCRLF() throws IOException {
                io.writeCRLF();
            }

            protected void write(CharSequence s) throws IOException {
                io.write(((Object)s).toString());
            }

            protected void write(char c) throws IOException {
                io.write(c);
            }

            protected void writeDel() throws IOException {
                io.writeDel();
            }

            protected boolean writeMoveLeft() throws IOException {
                return io.moveLeft();
            }

            protected boolean writeMoveRight() throws IOException {
                return io.moveRight();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.status.compareAndSet(0, 1)) {
            throw new IllegalStateException();
        }
        TermAction action = new TermAction.Init();
        while (this.status.get() == 1) {
            if (action == null) {
                try {
                    action = this._read();
                    this.log.debug("read term data " + action);
                }
                catch (IOException e) {
                    if (this.status.get() == 1) {
                        this.log.error("Could not read term data", (Throwable)e);
                    }
                    this.log.debug("Exception but term is considered as closed", (Throwable)e);
                    continue;
                }
            }
            Awaiter awaiter = null;
            Object object = this.lock;
            synchronized (object) {
                if (this.awaiters.size() > 0) {
                    awaiter = this.awaiters.removeFirst();
                }
            }
            TermAction action2 = action;
            action = null;
            if (awaiter != null) {
                awaiter.give(action2);
                continue;
            }
            TermResponseContext ctx = new TermResponseContext(){

                public void setEcho(boolean echo) {
                    BaseTerm.this.console.setEchoing(echo);
                }

                public TermAction read() throws IOException {
                    return BaseTerm.this.read();
                }

                public void write(String msg) throws IOException {
                    BaseTerm.this.write(msg);
                }

                public void setPrompt(String prompt) {
                    BaseTerm.this.prompt = prompt;
                }

                public void done(boolean close) {
                    try {
                        String p = BaseTerm.this.prompt == null ? "% " : BaseTerm.this.prompt;
                        BaseTerm.this.console.getWriter().write("\r\n");
                        BaseTerm.this.console.getWriter().write(p);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (close && BaseTerm.this.status.compareAndSet(1, 3)) {
                        BaseTerm.this.io.close();
                    }
                }
            };
            boolean processed = this.processor.process(action2, ctx);
            if (!processed) {
                this.log.debug("Pushing back action " + action2);
                action = action2;
                continue;
            }
            if (!(action2 instanceof TermAction.ReadLine)) continue;
            CharSequence line = ((TermAction.ReadLine)action2).getLine();
            this.historyCursor = -1;
            this.historyBuffer = null;
            if (line.length() <= 0) continue;
            this.history.addFirst(((TermAction.ReadLine)action2).getLine());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TermAction read() throws IOException {
        Awaiter awaiter;
        Object object = this.lock;
        synchronized (object) {
            awaiter = new Awaiter();
            this.awaiters.add(awaiter);
        }
        TermAction taken = awaiter.take();
        return taken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.status.compareAndSet(1, 3);
        if (this.status.compareAndSet(3, 4)) {
            try {
                this.log.debug("Closing connection");
                this.io.flush();
                this.io.close();
            }
            catch (IOException e) {
                this.log.debug("Exception thrown during term close()", (Throwable)e);
            }
            finally {
                this.status.set(2);
            }
        }
    }

    public TermAction _read() throws IOException {
        block8: do {
            int code = this.io.read();
            CodeType type = this.io.decode(code);
            switch (type) {
                case DELETE: {
                    this.console.getClientInput().del();
                    break;
                }
                case UP: 
                case DOWN: {
                    int nextHistoryCursor = this.historyCursor + (type == CodeType.UP ? 1 : -1);
                    if (nextHistoryCursor < -1 || nextHistoryCursor >= this.history.size()) continue block8;
                    CharSequence s = nextHistoryCursor == -1 ? this.historyBuffer : this.history.get(nextHistoryCursor);
                    CharSequence t = this.console.getClientInput().replace(s);
                    if (this.historyCursor == -1) {
                        this.historyBuffer = t;
                    }
                    if (nextHistoryCursor == -1) {
                        this.historyBuffer = null;
                    }
                    this.historyCursor = nextHistoryCursor;
                    break;
                }
                case RIGHT: {
                    this.console.getClientInput().moveRight();
                    break;
                }
                case LEFT: {
                    this.console.getClientInput().moveLeft();
                    break;
                }
                case BREAK: {
                    this.log.debug("Want to cancel evaluation");
                    this.console.clearBuffer();
                    return new TermAction.CancelEvaluation();
                }
                case CHAR: {
                    if (code >= 0 && code < 128) {
                        this.console.getClientInput().write((char)code);
                        break;
                    }
                    this.log.debug("Unhandled char " + code);
                }
            }
        } while (!this.console.getReader().hasNext());
        CharSequence input = this.console.getReader().next();
        return new TermAction.ReadLine(input);
    }

    public void write(String msg) throws IOException {
        this.console.getWriter().write(msg);
    }

    private static class Awaiter {
        TermAction action;

        private Awaiter() {
        }

        public synchronized void give(TermAction action) {
            this.action = action;
            this.notify();
        }

        public synchronized TermAction take() {
            try {
                this.wait();
                return this.action;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

