/*
 * Decompiled with CFR 0.152.
 */
package org.crsh;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.crsh.ProcessorListener;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.term.Term;
import org.crsh.term.TermEvent;
import org.crsh.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Processor
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(Processor.class);
    private static final int STATUS_INITIAL = 0;
    private static final int STATUS_OPEN = 1;
    private static final int STATUS_CLOSED = 2;
    private static final int STATUS_WANT_CLOSE = 3;
    private static final int STATUS_CLOSING = 4;
    private final Term term;
    private final AtomicInteger status;
    private final Shell shell;
    private volatile ShellProcess process;
    private final List<ProcessorListener> listeners;

    public Processor(Term term, Shell shell) {
        this.term = term;
        this.status = new AtomicInteger(0);
        this.shell = shell;
        this.process = null;
        this.listeners = new ArrayList<ProcessorListener>();
    }

    public void run() {
        try {
            this._run();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _run() throws InterruptedException {
        if (!this.status.compareAndSet(0, 1)) {
            throw new IllegalStateException();
        }
        try {
            this.main();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (this.status.get() == 3) {
                this.close();
            }
        }
    }

    private void main() {
        try {
            String welcome = this.shell.getWelcome();
            this.log.debug("Writing welcome message to term");
            this.term.write(welcome);
            this.log.debug("Wrote welcome message to term");
            this.writePrompt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (this.status.get() == 1) {
            TermEvent event = null;
            try {
                this.log.debug("About to read next term event");
                event = this.term.read();
                this.log.debug("Read next term event " + event);
            }
            catch (IOException e) {
                if (this.status.get() == 1) {
                    this.log.error("Could not read term data", (Throwable)e);
                }
                this.log.debug("Exception but term is considered as closed", (Throwable)e);
            }
            if (event == null) continue;
            if (event instanceof TermEvent.ReadLine) {
                String line = ((Object)((TermEvent.ReadLine)event).getLine()).toString();
                this.log.debug("Submitting command " + line);
                ShellInvoker invoker = new ShellInvoker();
                this.shell.process(((Object)((TermEvent.ReadLine)event).getLine()).toString(), invoker);
                if (line.length() <= 0) continue;
                this.term.addToHistory(line);
                continue;
            }
            if (event instanceof TermEvent.Break) {
                if (this.process != null) {
                    this.process.cancel();
                    continue;
                }
                this.log.debug("Ignoring action " + event);
                this.writePrompt();
                continue;
            }
            if (event instanceof TermEvent.Complete) {
                String commonCompletion;
                TermEvent.Complete complete = (TermEvent.Complete)event;
                String prefix = ((Object)complete.getLine()).toString();
                this.log.debug("About to get completions for " + prefix);
                Map<String, String> completions = this.shell.complete(prefix);
                this.log.debug("Completions for " + prefix + " are " + completions);
                if (completions.size() == 0) {
                    commonCompletion = "";
                } else if (completions.size() == 1) {
                    Map.Entry<String, String> entry = completions.entrySet().iterator().next();
                    commonCompletion = entry.getKey() + entry.getValue();
                } else {
                    commonCompletion = Strings.findLongestCommonPrefix(completions.keySet());
                }
                if (commonCompletion.length() > 0) {
                    try {
                        this.term.bufferInsert(commonCompletion);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (completions.size() <= 1) continue;
                StringBuilder sb = new StringBuilder("\n");
                Iterator<String> i = completions.keySet().iterator();
                while (i.hasNext()) {
                    String completion = i.next();
                    sb.append(completion);
                    if (!i.hasNext()) continue;
                    sb.append(" ");
                }
                sb.append("\n");
                try {
                    this.term.write(sb.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.writePrompt();
                continue;
            }
            if (!(event instanceof TermEvent.Close)) continue;
            this.status.compareAndSet(1, 3);
        }
    }

    private void writePrompt() {
        String prompt = this.shell.getPrompt();
        try {
            String p = prompt == null ? "% " : prompt;
            this.term.write("\r\n");
            this.term.write(p);
            this.term.write(this.term.getBuffer());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ProcessorListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        List<ProcessorListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(listener)) {
                throw new IllegalStateException("Already listening");
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        this.status.compareAndSet(1, 3);
        if (this.status.compareAndSet(3, 4)) {
            this.log.debug("Closing processor");
            ArrayList<ProcessorListener> listeners = new ArrayList<ProcessorListener>();
            List<ProcessorListener> list = this.listeners;
            synchronized (list) {
                listeners.addAll(this.listeners);
            }
            this.status.set(2);
            for (ProcessorListener listener : listeners) {
                try {
                    this.log.debug("Closing " + listener.getClass().getSimpleName());
                    listener.closed();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class ShellInvoker
    implements ShellProcessContext {
        private ShellInvoker() {
        }

        public int getWidth() {
            return Processor.this.term.getWidth();
        }

        public void begin(ShellProcess process) {
            Processor.this.process = process;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String readLine(String msg, boolean echo) {
            try {
                Processor.this.term.setEcho(echo);
                Processor.this.term.write(msg);
                TermEvent action = Processor.this.term.read();
                CharSequence line = null;
                if (action instanceof TermEvent.ReadLine) {
                    line = ((TermEvent.ReadLine)action).getLine();
                    Processor.this.log.debug("Read from console");
                } else {
                    Processor.this.log.debug("Ignoring action " + action + " returning null");
                }
                Processor.this.term.write("\r\n");
                String string = ((Object)line).toString();
                return string;
            }
            catch (Exception e) {
                Processor.this.log.error("Reading from console failed", (Throwable)e);
                String string = null;
                return string;
            }
            finally {
                Processor.this.term.setEcho(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end(ShellResponse response) {
            block7: {
                try {
                    if (response instanceof ShellResponse.Close) {
                        Processor.this.term.close();
                        break block7;
                    }
                    if (!(response instanceof ShellResponse.Cancelled)) {
                        String ret = response.getText();
                        Processor.this.log.debug("Command completed with result " + ret);
                        try {
                            Processor.this.term.write(ret);
                        }
                        catch (IOException e) {
                            Processor.this.log.error("Write to term failure", (Throwable)e);
                        }
                        Processor.this.process = null;
                    }
                    Processor.this.writePrompt();
                }
                finally {
                    Processor.this.process = null;
                }
            }
        }
    }
}

