/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.crsh.plugin.PluginContext;
import org.crsh.shell.ShellFactory;

public abstract class CRaSHLifeCycle {
    private ShellFactory builder;
    private final PluginContext context;
    private ExecutorService executor;

    protected CRaSHLifeCycle(PluginContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.context = context;
    }

    public final void init() {
        ShellFactory builder;
        ExecutorService executor = Executors.newFixedThreadPool(3);
        this.builder = builder = new ShellFactory(this.context);
        this.executor = executor;
        try {
            this.doInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void destroy() {
        this.doDestroy();
        this.executor.shutdownNow();
        this.executor = null;
        this.builder = null;
    }

    public final ExecutorService getExecutor() {
        return this.executor;
    }

    public final ShellFactory getShellFactory() {
        return this.builder;
    }

    public final PluginContext getShellContext() {
        return this.context;
    }

    protected abstract void doInit() throws Exception;

    protected abstract void doDestroy();
}

