/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PluginContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager<P extends CRaSHPlugin> {
    private final Logger log = LoggerFactory.getLogger(PluginManager.class);
    private final PluginContext context;
    private List<P> plugins;
    private final Class<P> pluginType;

    public PluginManager(PluginContext context, Class<P> pluginType) {
        this.context = context;
        this.pluginType = pluginType;
        this.plugins = null;
    }

    public synchronized Iterable<P> getPlugins() {
        if (this.plugins == null) {
            ArrayList<P> plugins = new ArrayList<P>();
            try {
                ServiceLoader<CRaSHPlugin> loader = ServiceLoader.load(this.pluginType, this.context.getLoader());
                for (CRaSHPlugin plugin : loader) {
                    this.log.info("Loaded plugin " + plugin);
                    plugins.add(plugin);
                }
            }
            catch (ServiceConfigurationError e) {
                this.log.error("Could not load plugins of type " + this.pluginType, e);
            }
            Iterator i = plugins.iterator();
            while (i.hasNext()) {
                CRaSHPlugin plugin = (CRaSHPlugin)i.next();
                plugin.context = this.context;
                try {
                    plugin.init();
                    this.log.info("Initialized plugin " + plugin);
                }
                catch (Exception e) {
                    i.remove();
                    this.log.error("Could not initialize plugin " + plugin, e);
                }
            }
            this.plugins = plugins;
        }
        return this.plugins;
    }

    public void shutdown() {
        for (CRaSHPlugin plugin : this.plugins) {
            plugin.destroy();
        }
    }
}

