/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import java.util.Arrays;
import junit.framework.TestCase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.crsh.cmdline.matcher.CmdSyntaxException;
import org.crsh.command.ClassCommand;
import org.crsh.command.ScriptException;
import org.crsh.command.ShellCommand;
import org.crsh.shell.TestInvocationContext;
import org.crsh.shell.impl.GroovyScriptCommand;
import org.kohsuke.args4j.CmdLineException;

public class ShellCommandTestCase
extends TestCase {
    private GroovyClassLoader loader;
    private GroovyShell shell;

    protected void setUp() throws Exception {
        CompilerConfiguration config = new CompilerConfiguration();
        config.setScriptBaseClass(GroovyScriptCommand.class.getName());
        this.loader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader(), config);
        this.shell = new GroovyShell((ClassLoader)this.loader);
    }

    public void testOptionInjectionInCommandClassArgs4j() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.ClassCommand { @org.kohsuke.args4j.Option(name=\"-str\", required = true) def String str = 'default value';public Object execute() {return str;}}");
        ClassCommand cmd = (ClassCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)"abc", (String)new TestInvocationContext().execute((ShellCommand)cmd, "-str", "abc"));
        try {
            new TestInvocationContext().execute((ShellCommand)cmd, new String[0]);
        }
        catch (ScriptException e) {
            ShellCommandTestCase.assertTrue((boolean)(e.getCause() instanceof CmdLineException));
        }
    }

    public void testOptionInjectionInCommandClassCmdLine() throws Exception {
        block2: {
            Class clazz = this.loader.parseClass("class foo extends org.crsh.command.CRaSHCommand { @Option(names=\"s\") @Required def String str = 'default value';@Command\npublic Object main() {return str;}}");
            ShellCommand command = (ShellCommand)clazz.newInstance();
            ShellCommandTestCase.assertEquals((String)"abc", (String)new TestInvocationContext().execute(command, "-s", "abc"));
            try {
                new TestInvocationContext().execute(command, new String[0]);
                ShellCommandTestCase.fail();
            }
            catch (ScriptException e) {
                if ($assertionsDisabled || e.getCause() instanceof CmdSyntaxException) break block2;
                throw new AssertionError();
            }
        }
    }

    public void testContextAccessFromCommandClassCmdLine() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.CRaSHCommand { @Command\npublic Object main() {return juu;}}");
        ShellCommand cmd = (ShellCommand)clazz.newInstance();
        TestInvocationContext ctx = new TestInvocationContext();
        ctx.getAttributes().put("juu", "daa");
        ShellCommandTestCase.assertEquals((String)"daa", (String)ctx.execute(cmd, new String[0]));
    }

    public void testArgumentInjectionInCommandClassArgs4j() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.ClassCommand { @org.kohsuke.args4j.Argument def String str;public Object execute() {return str;}}");
        ClassCommand cmd = (ClassCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)"b", (String)new TestInvocationContext().execute((ShellCommand)cmd, "b"));
    }

    public void testArgumentInjectionInCommandCmdLine() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.CRaSHCommand { @Command\npublic Object main(@Argument String str) {return str;}}");
        ShellCommand cmd = (ShellCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)"b", (String)new TestInvocationContext().execute(cmd, "b"));
    }

    public void testMainInCommandCmdLine() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.CRaSHCommand { @Command\npublic Object main() {return 'foo';}}");
        ShellCommand cmd = (ShellCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)"foo", (String)new TestInvocationContext().execute(cmd, new String[0]));
    }

    public void testContextAccessInCommandClass() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.ClassCommand { public Object execute() {return bar;}}");
        TestInvocationContext ctx = new TestInvocationContext();
        ctx.getAttributes().put("bar", "bar_value");
        ClassCommand cmd = (ClassCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)"bar_value", (String)ctx.execute((ShellCommand)cmd, new String[0]));
    }

    public void testClosureInvocationInClass() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.ClassCommand { public Object execute() {return bar();}}");
        TestInvocationContext ctx = new TestInvocationContext();
        Closure closure = (Closure)this.shell.evaluate("{ -> return 'from_closure'; }");
        ctx.getAttributes().put("bar", closure);
        ClassCommand cmd = (ClassCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)"from_closure", (String)ctx.execute((ShellCommand)cmd, new String[0]));
    }

    public void testArgumentQuoteInClass() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.ClassCommand {\n@org.kohsuke.args4j.Argument\ndef List<String> arguments;\npublic Object execute() {\nreturn arguments;\n}\n}\n");
        ClassCommand cmd = (ClassCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)("" + Arrays.asList("foo")), (String)new TestInvocationContext().execute((ShellCommand)cmd, "'foo'"));
    }

    public void testArgumentQuoteInClass2() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.ClassCommand {\n@org.kohsuke.args4j.Argument\ndef List<String> arguments;\n{ unquoteArguments = false; }\npublic Object execute() {\nreturn arguments;\n}\n}\n");
        ClassCommand cmd = (ClassCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)("" + Arrays.asList("'foo'")), (String)new TestInvocationContext().execute((ShellCommand)cmd, "'foo'"));
    }

    public void testContextAccessInScript() throws Exception {
        Class clazz = this.loader.parseClass("System.out.println('bar:' + bar) ; return bar;");
        ShellCommand script = (ShellCommand)clazz.newInstance();
        TestInvocationContext ctx = new TestInvocationContext();
        ctx.getAttributes().put("bar", "bar_value");
        ShellCommandTestCase.assertEquals((String)"bar_value", (String)ctx.execute(script, new String[0]));
    }

    public void testArgumentAccessInScript() throws Exception {
        Class clazz = this.loader.parseClass("return args[0];");
        ShellCommand script = (ShellCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)"arg_value", (String)new TestInvocationContext().execute(script, "arg_value"));
    }

    public void testArgumentAccessInClosure() throws Exception {
        Class clazz = this.loader.parseClass("{ arg -> return arg };");
        ShellCommand script = (ShellCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)"arg_value", (String)new TestInvocationContext().execute(script, "arg_value"));
    }
}

