/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.concurrent;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.concurrent.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncShell
implements Shell {
    private final Object lock = new Object();
    private Status status = Status.AVAILABLE;
    private Shell shell;
    private Foo current;
    private final ExecutorService executor;

    public AsyncShell(ExecutorService executor, Shell shell) {
        this.shell = shell;
        this.current = null;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getStatus() {
        Object object = this.lock;
        synchronized (object) {
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            switch (this.status) {
                case INITIAL: 
                case AVAILABLE: {
                    break;
                }
                case CANCELED: 
                case EVALUATING: {
                    throw new UnsupportedOperationException("todo :-) " + (Object)((Object)this.status));
                }
            }
            this.status = Status.CLOSED;
        }
    }

    @Override
    public String getWelcome() {
        return this.shell.getWelcome();
    }

    @Override
    public String getPrompt() {
        return this.shell.getPrompt();
    }

    @Override
    public Map<String, String> complete(String prefix) {
        return this.shell.complete(prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String request, ShellProcessContext processContext) {
        Object object = this.lock;
        synchronized (object) {
            if (this.status != Status.AVAILABLE) {
                throw new IllegalStateException("State was " + (Object)((Object)this.status));
            }
            this.status = Status.EVALUATING;
            this.current = new Foo(request, processContext);
        }
        this.executor.submit(this.current);
    }

    private class Foo
    implements ShellProcessContext,
    Runnable,
    ShellProcess {
        private final String request;
        private final ShellProcessContext caller;
        private ShellProcess callee;

        private Foo(String request, ShellProcessContext caller) {
            this.request = request;
            this.caller = caller;
            this.callee = null;
        }

        public int getWidth() {
            return this.caller.getWidth();
        }

        public String readLine(String msg, boolean echo) {
            return this.caller.readLine(msg, echo);
        }

        public void begin(ShellProcess process) {
            this.caller.begin(this);
            this.callee = process;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end(ShellResponse response) {
            Object object = AsyncShell.this.lock;
            synchronized (object) {
                if (AsyncShell.this.status == Status.CANCELED) {
                    this.caller.end(new ShellResponse.Cancelled());
                } else {
                    this.caller.end(response);
                }
                AsyncShell.this.current = null;
                AsyncShell.this.status = Status.AVAILABLE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = AsyncShell.this.lock;
            synchronized (object) {
                if (AsyncShell.this.status == Status.EVALUATING) {
                    AsyncShell.this.status = Status.CANCELED;
                    this.callee.cancel();
                }
            }
        }

        public void run() {
            AsyncShell.this.shell.process(this.request, AsyncShell.this.current);
        }
    }
}

