/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import org.crsh.command.ScriptException;
import org.crsh.shell.impl.Token;

class Tokenizer {
    private final CharSequence s;
    private int index;
    private Character c;

    public Tokenizer(CharSequence s) throws NullPointerException {
        if (s == null) {
            throw new NullPointerException();
        }
        this.s = s;
        this.index = 0;
        this.c = this.index < s.length() ? Character.valueOf(s.charAt(this.index++)) : null;
    }

    private void next() {
        this.c = this.index < this.s.length() ? Character.valueOf(this.s.charAt(this.index++)) : null;
    }

    public Token nextToken() {
        if (this.c == null) {
            return Token.EOF;
        }
        switch (this.c.charValue()) {
            case '+': {
                this.next();
                return Token.PLUS;
            }
            case '|': {
                this.next();
                return Token.PIPE;
            }
        }
        return this.parseCommand();
    }

    private Token parseCommand() throws ScriptException {
        StringBuilder line = new StringBuilder();
        Character lastQuote = null;
        while (this.c != null && (lastQuote != null || this.c.charValue() != '+' && this.c.charValue() != '|')) {
            line.append(this.c);
            switch (this.c.charValue()) {
                case '\"': 
                case '\'': {
                    if (lastQuote == null) {
                        lastQuote = this.c;
                        break;
                    }
                    if (lastQuote != this.c) break;
                    lastQuote = null;
                    break;
                }
            }
            this.next();
        }
        return new Token.Command(line.toString());
    }
}

