/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import org.crsh.shell.ErrorType;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.AST;
import org.crsh.shell.impl.CRaSH;
import org.crsh.shell.impl.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommandExecution
implements ShellProcess {
    private static final Logger log = LoggerFactory.getLogger(CRaSH.class);
    private final CRaSH crash;
    private final String request;
    private final ShellProcessContext context;

    CommandExecution(CRaSH crash, String request, ShellProcessContext context) {
        this.crash = crash;
        this.request = request;
        this.context = context;
    }

    void execute() {
        ShellResponse resp;
        this.context.begin(this);
        if ("bye".equals(this.request)) {
            resp = new ShellResponse.Close();
        } else {
            Parser parser = new Parser(this.request);
            AST ast = parser.parse();
            if (ast instanceof AST.Expr) {
                AST.Expr expr = (AST.Expr)ast;
                try {
                    resp = expr.createCommands(this.crash);
                }
                catch (Exception e) {
                    resp = new ShellResponse.Error(ErrorType.EVALUATION, e);
                }
                if (resp == null) {
                    resp = expr.execute(this.context, this.crash.attributes);
                }
            } else {
                resp = new ShellResponse.NoCommand();
            }
        }
        if (resp instanceof ShellResponse.Error) {
            ShellResponse.Error error = (ShellResponse.Error)resp;
            Throwable t = error.getThrowable();
            if (t != null) {
                log.error("Error while evaluating request '" + this.request + "' " + error.getText(), t);
            } else {
                log.error("Error while evaluating request '" + this.request + "' " + error.getText());
            }
        }
        this.context.end(resp);
    }

    public void cancel() {
    }
}

