/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import org.crsh.shell.ErrorType;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.CRaSH;

abstract class CRaSHProcess
implements ShellProcess {
    protected final CRaSH crash;
    protected final String request;

    protected CRaSHProcess(CRaSH crash, String request) {
        this.crash = crash;
        this.request = request;
    }

    public void execute(ShellProcessContext processContext) {
        ShellResponse resp;
        try {
            resp = this.invoke(processContext);
        }
        catch (Throwable t) {
            resp = new ShellResponse.Error(ErrorType.INTERNAL, t);
        }
        processContext.end(resp);
        if (resp instanceof ShellResponse.Error) {
            ShellResponse.Error error = (ShellResponse.Error)resp;
            Throwable t = error.getThrowable();
            if (t != null) {
                CRaSH.log.error("Error while evaluating request '" + this.request + "' " + error.getText(), t);
            } else {
                CRaSH.log.error("Error while evaluating request '" + this.request + "' " + error.getText());
            }
        }
    }

    abstract ShellResponse invoke(ShellProcessContext var1);

    public void cancel() {
    }
}

