/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.AST;
import org.crsh.shell.impl.CRaSH;
import org.crsh.shell.impl.CRaSHProcess;
import org.crsh.shell.impl.CreateCommandException;
import org.crsh.shell.impl.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CRaSHProcessFactory {
    private static final Logger log = LoggerFactory.getLogger(CRaSH.class);
    private final CRaSH crash;
    private final String request;

    CRaSHProcessFactory(CRaSH crash, String request) {
        this.crash = crash;
        this.request = request;
    }

    CRaSHProcess create() {
        if ("bye".equals(this.request)) {
            return new SimpleProcess(this.crash, this.request, new ShellResponse.Close());
        }
        Parser parser = new Parser(this.request);
        AST ast = parser.parse();
        if (ast instanceof AST.Expr) {
            AST.Expr expr = (AST.Expr)ast;
            try {
                return expr.create(this.crash, this.request);
            }
            catch (CreateCommandException e) {
                return new SimpleProcess(this.crash, this.request, e.getResponse());
            }
        }
        return new SimpleProcess(this.crash, this.request, new ShellResponse.NoCommand());
    }

    private static class SimpleProcess
    extends CRaSHProcess {
        private final ShellResponse response;

        private SimpleProcess(CRaSH crash, String request, ShellResponse response) {
            super(crash, request);
            this.response = response;
        }

        ShellResponse invoke(ShellProcessContext context) {
            return this.response;
        }
    }
}

