/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.crsh.cmdline.ArgumentDescriptor;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.MethodDescriptor;
import org.crsh.cmdline.OptionDescriptor;
import org.crsh.cmdline.binding.ClassFieldBinding;
import org.crsh.cmdline.binding.MethodArgumentBinding;
import org.crsh.cmdline.binding.TypeBinding;
import org.crsh.cmdline.matcher.ArgumentMatch;
import org.crsh.cmdline.matcher.ClassMatch;
import org.crsh.cmdline.matcher.CmdCompletionException;
import org.crsh.cmdline.matcher.CommandMatch;
import org.crsh.cmdline.matcher.LiteralValue;
import org.crsh.cmdline.matcher.Matcher;
import org.crsh.cmdline.matcher.MethodMatch;
import org.crsh.cmdline.matcher.OptionMatch;
import org.crsh.cmdline.matcher.impl.Completion;
import org.crsh.cmdline.matcher.impl.EmptyCompletion;
import org.crsh.cmdline.matcher.impl.Event;
import org.crsh.cmdline.matcher.impl.MethodCompletion;
import org.crsh.cmdline.matcher.impl.Mode;
import org.crsh.cmdline.matcher.impl.OptionCompletion;
import org.crsh.cmdline.matcher.impl.ParameterCompletion;
import org.crsh.cmdline.matcher.impl.Parser;
import org.crsh.cmdline.matcher.impl.SpaceCompletion;
import org.crsh.cmdline.matcher.tokenizer.Termination;
import org.crsh.cmdline.matcher.tokenizer.Token;
import org.crsh.cmdline.matcher.tokenizer.Tokenizer;
import org.crsh.cmdline.spi.Completer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatcherImpl<T>
extends Matcher<T> {
    private final ClassDescriptor<T> descriptor;
    private final String mainName;

    public MatcherImpl(ClassDescriptor<T> descriptor) {
        this(null, descriptor);
    }

    public MatcherImpl(String mainName, ClassDescriptor<T> descriptor) {
        this.mainName = mainName;
        this.descriptor = descriptor;
    }

    private List<LiteralValue> bilto(List<? extends Token.Literal> literals) {
        ArrayList<LiteralValue> values = new ArrayList<LiteralValue>(literals.size());
        for (Token.Literal literal : literals) {
            values.add(new LiteralValue(literal.getRaw(), literal.getValue()));
        }
        return values;
    }

    @Override
    public CommandMatch<T, ?, ?> match(String s) {
        Integer classEnd;
        Tokenizer tokenizer = new Tokenizer(s);
        Parser<T> parser = new Parser<T>(tokenizer, this.descriptor, this.mainName, Mode.INVOKE);
        ArrayList<OptionMatch<ClassFieldBinding>> classOptions = new ArrayList<OptionMatch<ClassFieldBinding>>();
        ArrayList<ArgumentMatch<ClassFieldBinding>> classArguments = new ArrayList<ArgumentMatch<ClassFieldBinding>>();
        ArrayList<OptionMatch<MethodArgumentBinding>> methodOptions = new ArrayList<OptionMatch<MethodArgumentBinding>>();
        ArrayList<ArgumentMatch<MethodArgumentBinding>> methodArguments = new ArrayList<ArgumentMatch<MethodArgumentBinding>>();
        MethodDescriptor<Object> method = null;
        Integer methodEnd = null;
        Event previous = null;
        while (true) {
            Event event;
            if (!((event = parser.next()) instanceof Event.Separator)) {
                Event.Argument argumentEvent;
                List values;
                if (event instanceof Event.Stop) {
                    Event.Stop end = (Event.Stop)event;
                    int endIndex = previous instanceof Event.Separator ? ((Event.Separator)previous).getToken().getFrom() : end.getIndex();
                    if (method == null) {
                        classEnd = endIndex;
                        if (this.mainName != null) {
                            method = this.descriptor.getMethod(this.mainName);
                        }
                        if (method == null) break;
                        methodEnd = classEnd;
                        break;
                    }
                    methodEnd = classEnd = Integer.valueOf(endIndex);
                    break;
                }
                if (event instanceof Event.Option) {
                    Event.Option optionEvent = (Event.Option)event;
                    OptionDescriptor desc = (OptionDescriptor)optionEvent.getDescriptor();
                    ArrayList<OptionMatch<TypeBinding>> options = desc.getOwner() instanceof ClassDescriptor ? classOptions : methodOptions;
                    boolean done = false;
                    ListIterator i = options.listIterator();
                    while (i.hasNext()) {
                        OptionMatch om = (OptionMatch)i.next();
                        if (!om.getParameter().equals(desc)) continue;
                        ArrayList<LiteralValue> v = new ArrayList<LiteralValue>(om.getValues());
                        v.addAll(this.bilto(optionEvent.getValues()));
                        ArrayList<String> names = new ArrayList<String>(om.getNames());
                        names.add(optionEvent.getToken().getName());
                        i.set(new OptionMatch(desc, names, v));
                        done = true;
                        break;
                    }
                    if (!done) {
                        OptionMatch match = new OptionMatch(desc, optionEvent.getToken().getName(), this.bilto(optionEvent.getValues()));
                        options.add(match);
                    }
                } else if (event instanceof Event.Method) {
                    if (event instanceof Event.Method.Implicit) {
                        Event.Method.Implicit implicit = (Event.Method.Implicit)event;
                        classEnd = implicit.getTrigger().getFrom();
                        method = implicit.getDescriptor();
                    } else {
                        Event.Method.Explicit explicit = (Event.Method.Explicit)event;
                        classEnd = explicit.getToken().getFrom();
                        method = explicit.getDescriptor();
                    }
                } else if (event instanceof Event.Argument && (values = (argumentEvent = (Event.Argument)event).getValues()).size() > 0) {
                    ArgumentMatch match = new ArgumentMatch((ArgumentDescriptor)argumentEvent.getDescriptor(), argumentEvent.getFrom(), argumentEvent.getTo(), this.bilto(argumentEvent.getValues()));
                    if (((ArgumentDescriptor)argumentEvent.getDescriptor()).getOwner() instanceof ClassDescriptor) {
                        classArguments.add(match);
                    } else {
                        methodArguments.add(match);
                    }
                }
            }
            previous = event;
        }
        ClassMatch<T> classMatch = new ClassMatch<T>(this.descriptor, classOptions, classArguments, s.substring(classEnd));
        if (method != null) {
            return new MethodMatch<T>(classMatch, method, false, methodOptions, methodArguments, s.substring(methodEnd));
        }
        return classMatch;
    }

    private Completion argument(MethodDescriptor<?> method, Completer completer) {
        List arguments = method.getArguments();
        if (arguments.isEmpty()) {
            return new EmptyCompletion();
        }
        ArgumentDescriptor argument = arguments.get(0);
        return new ParameterCompletion("", Termination.DETERMINED, argument, completer);
    }

    @Override
    public Map<String, String> complete(Completer completer, String s) throws CmdCompletionException {
        return this.getCompletion(completer, s).complete();
    }

    private Completion getCompletion(Completer completer, String s) throws CmdCompletionException {
        Event event;
        Tokenizer tokenizer = new Tokenizer(s);
        Parser<T> parser = new Parser<T>(tokenizer, this.descriptor, this.mainName, Mode.COMPLETE);
        Event last = null;
        Event.Separator separator = null;
        MethodDescriptor<Object> method = null;
        while (true) {
            if ((event = parser.next()) instanceof Event.Separator) {
                separator = (Event.Separator)event;
                continue;
            }
            if (event instanceof Event.Stop) break;
            if (event instanceof Event.Option) {
                last = event;
                separator = null;
                continue;
            }
            if (event instanceof Event.Method) {
                method = ((Event.Method)event).getDescriptor();
                last = event;
                separator = null;
                continue;
            }
            if (!(event instanceof Event.Argument)) continue;
            last = event;
            separator = null;
        }
        Event.Stop stop = (Event.Stop)event;
        if (stop instanceof Event.Stop.Unresolved.NoSuchOption) {
            Event.Stop.Unresolved.NoSuchOption nso = (Event.Stop.Unresolved.NoSuchOption)stop;
            return new OptionCompletion(method != null ? method : this.descriptor, (Token.Literal.Option)nso.getToken());
        }
        if (stop instanceof Event.Stop.Unresolved) {
            if (stop instanceof Event.Stop.Unresolved.TooManyArguments) {
                if (method == null) {
                    Event.Stop.Unresolved.TooManyArguments tma = (Event.Stop.Unresolved.TooManyArguments)stop;
                    return new MethodCompletion<T>(this.descriptor, this.mainName, s.substring(stop.getIndex()), parser.getTermination());
                }
                return new EmptyCompletion();
            }
            return new EmptyCompletion();
        }
        if (stop instanceof Event.Stop.Done.Option || stop instanceof Event.Stop.Done.Arg) {
            // empty if block
        }
        if (last == null) {
            if (method == null) {
                if (((Object)this.descriptor.getSubordinates().keySet()).equals(Collections.singleton(this.mainName))) {
                    method = this.descriptor.getMethod(this.mainName);
                    List args = method.getArguments();
                    if (args.size() > 0) {
                        return new ParameterCompletion("", Termination.DETERMINED, args.get(0), completer);
                    }
                    return new EmptyCompletion();
                }
                return new MethodCompletion<T>(this.descriptor, this.mainName, s.substring(stop.getIndex()), Termination.DETERMINED);
            }
            return new EmptyCompletion();
        }
        if (last instanceof Event.Option) {
            Event.Option optionEvent = (Event.Option)last;
            List values = optionEvent.getValues();
            OptionDescriptor option = (OptionDescriptor)optionEvent.getDescriptor();
            if (separator == null) {
                if (values.size() == 0) {
                    return new SpaceCompletion();
                }
                if (values.size() <= option.getArity()) {
                    Token.Literal.Word word = (Token.Literal.Word)optionEvent.peekLast();
                    return new ParameterCompletion(word.getValue(), parser.getTermination(), option, completer);
                }
                return new EmptyCompletion();
            }
            if (values.size() < option.getArity()) {
                return new ParameterCompletion("", Termination.DETERMINED, option, completer);
            }
            if (method == null) {
                return new MethodCompletion<T>(this.descriptor, this.mainName, s.substring(stop.getIndex()), Termination.DETERMINED);
            }
            return this.argument(method, completer);
        }
        if (last instanceof Event.Argument) {
            Event.Argument eventArgument = (Event.Argument)last;
            ArgumentDescriptor argument = (ArgumentDescriptor)eventArgument.getDescriptor();
            if (separator != null) {
                switch (argument.getMultiplicity()) {
                    case SINGLE: {
                        List arguments = argument.getOwner().getArguments();
                        int index = arguments.indexOf(argument) + 1;
                        if (index < arguments.size()) {
                            throw new UnsupportedOperationException("Need to find next argument and use it for completion");
                        }
                        return new EmptyCompletion();
                    }
                    case MULTI: {
                        return new ParameterCompletion("", Termination.DETERMINED, argument, completer);
                    }
                }
                throw new AssertionError();
            }
            Object value = eventArgument.peekLast();
            return new ParameterCompletion(((Token.Literal)value).getValue(), parser.getTermination(), argument, completer);
        }
        if (last instanceof Event.Method) {
            if (separator != null) {
                return this.argument(method, completer);
            }
            return new SpaceCompletion();
        }
        throw new AssertionError();
    }
}

