/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.util.Collections;
import org.crsh.command.ScriptException;
import org.crsh.shell.ErrorType;

public abstract class ShellResponse {
    public abstract String getText();

    public static class Error
    extends ShellResponse {
        private final ErrorType type;
        private final Throwable throwable;
        private final String msg;

        public Error(ErrorType type, Throwable throwable) {
            this.type = type;
            this.msg = Error.build(throwable);
            this.throwable = throwable;
        }

        public Error(ErrorType type, String msg) {
            this.type = type;
            this.msg = msg;
            this.throwable = null;
        }

        public Error(ErrorType type, String msg, Throwable throwable) {
            this.type = type;
            this.msg = msg;
            this.throwable = throwable;
        }

        public ErrorType getType() {
            return this.type;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public String getText() {
            return this.msg;
        }

        private static String build(Throwable throwable) {
            String msg = throwable.getMessage();
            if (msg == null) {
                msg = throwable.getClass().getSimpleName();
            }
            String result = throwable instanceof ScriptException ? "Error: " + msg : (throwable instanceof RuntimeException ? "Unexpected exception: " + msg : (throwable instanceof Exception ? "Unexpected exception: " + msg : (throwable instanceof java.lang.Error ? "Unexpected error: " + msg : "Unexpected throwable: " + msg)));
            return result;
        }

        public String toString() {
            return "ShellResponse.Error[type=" + (Object)((Object)this.type) + ",msg=" + this.msg + "]";
        }
    }

    public static class Cancelled
    extends ShellResponse {
        public String getText() {
            return "cancelled";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Display
    extends Ok {
        private final String text;

        public Display(String text) {
            this.text = text;
        }

        public Display(Iterable<?> produced, String text) {
            super(produced);
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Ok
    extends ShellResponse {
        private final Iterable<?> produced;

        public Ok() {
            this(Collections.emptyList());
        }

        public Ok(Iterable<?> produced) {
            this.produced = produced;
        }

        public Iterable<?> getProduced() {
            return this.produced;
        }

        @Override
        public String getText() {
            return "";
        }
    }

    public static class Close
    extends ShellResponse {
        public String getText() {
            return "Have a good day!\r\n";
        }
    }

    public static class NoCommand
    extends ShellResponse {
        public String getText() {
            return "Please type something";
        }
    }

    public static class UnknownCommand
    extends ShellResponse {
        private final String name;

        public UnknownCommand(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getText() {
            return "Unknown command " + this.name;
        }
    }

    public static class SyntaxError
    extends ShellResponse {
        public String getText() {
            return "Syntax error";
        }
    }
}

