/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.concurrent;

import java.util.concurrent.CountDownLatch;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;

public class SyncShellResponseContext
implements ShellProcessContext {
    private final ShellProcessContext wrapped;
    private ShellResponse response;
    private final CountDownLatch latch;
    private ShellProcess process;

    public SyncShellResponseContext() {
        this(null);
    }

    public SyncShellResponseContext(ShellProcessContext wrapped) {
        this.wrapped = wrapped;
        this.latch = new CountDownLatch(1);
        this.response = null;
    }

    public int getWidth() {
        return this.wrapped.getWidth();
    }

    public String getProperty(String name) {
        return this.wrapped.getProperty(name);
    }

    public String readLine(String msg, boolean echo) {
        if (this.wrapped != null) {
            return this.wrapped.readLine(msg, echo);
        }
        return null;
    }

    public void end(ShellResponse response) {
        this.response = response;
        this.latch.countDown();
        if (this.wrapped != null) {
            this.wrapped.end(response);
        }
    }

    public ShellResponse getResponse() throws InterruptedException {
        this.latch.await();
        return this.response;
    }
}

