/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term;

import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.crsh.BaseProcess;
import org.crsh.BaseProcessFactory;
import org.crsh.BaseShell;
import org.crsh.TestPluginContext;
import org.crsh.plugin.PluginContext;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellFactory;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.concurrent.AsyncShell;
import org.crsh.shell.concurrent.Status;
import org.crsh.shell.concurrent.SyncShellResponseContext;

public class AsyncShellTestCase
extends TestCase {
    protected ShellFactory builder;
    protected TestPluginContext context;
    protected ExecutorService executor;
    private static volatile int status;

    protected void setUp() throws Exception {
        super.setUp();
        this.executor = Executors.newSingleThreadExecutor();
        this.context = new TestPluginContext();
        this.builder = new ShellFactory((PluginContext)this.context);
    }

    public void testReadLine() throws Exception {
        final LinkedList output = new LinkedList();
        final LinkedList<String> input = new LinkedList<String>();
        input.add("juu");
        BaseProcessFactory factory = new BaseProcessFactory(){

            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    protected ShellResponse execute(String request) {
                        String a = this.readLine("bar", true);
                        return new ShellResponse.Display(a);
                    }
                };
            }
        };
        BaseShell shell = new BaseShell(factory);
        AsyncShell asyncShell = new AsyncShell(this.executor, (Shell)shell);
        ShellProcessContext respCtx1 = new ShellProcessContext(){

            public int getWidth() {
                return 32;
            }

            public String getProperty(String name) {
                return null;
            }

            public void begin(ShellProcess process) {
            }

            public String readLine(String msg, boolean echo) {
                output.addLast(msg);
                return input.isEmpty() ? null : (String)input.removeLast();
            }

            public void end(ShellResponse response) {
            }
        };
        SyncShellResponseContext respCtx2 = new SyncShellResponseContext(respCtx1);
        asyncShell.createProcess("foo").execute((ShellProcessContext)respCtx2);
        ShellResponse resp = respCtx2.getResponse();
        AsyncShellTestCase.assertTrue((boolean)(resp instanceof ShellResponse.Display));
        AsyncShellTestCase.assertEquals((String)"juu", (String)resp.getText());
        AsyncShellTestCase.assertEquals(Collections.singletonList("bar"), output);
        AsyncShellTestCase.assertEquals((int)0, (int)input.size());
    }

    public void testCancelEvaluation() throws InterruptedException {
        ShellResponse.Ok ok = new ShellResponse.Ok();
        final AtomicBoolean fail = new AtomicBoolean(false);
        final AtomicInteger status = new AtomicInteger(0);
        AtomicInteger cancelled = new AtomicInteger(0);
        BaseProcessFactory factory = new BaseProcessFactory((ShellResponse)ok, cancelled){
            final /* synthetic */ ShellResponse val$ok;
            final /* synthetic */ AtomicInteger val$cancelled;
            {
                this.val$ok = shellResponse;
                this.val$cancelled = atomicInteger2;
            }

            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    protected ShellResponse execute(String request) {
                        fail.set(!"foo".equals(request));
                        if (status.get() == 0) {
                            status.set(1);
                            int r = status.get();
                            while (r == 1) {
                                r = status.get();
                            }
                            if (r == 2) {
                                status.set(3);
                            } else {
                                status.set(-1);
                            }
                        } else {
                            status.set(-1);
                        }
                        return val$ok;
                    }

                    public void cancel() {
                        val$cancelled.getAndIncrement();
                    }
                };
            }
        };
        BaseShell shell = new BaseShell(factory);
        AsyncShell asyncShell = new AsyncShell(this.executor, (Shell)shell);
        SyncShellResponseContext respCtx = new SyncShellResponseContext();
        ShellProcess process = asyncShell.createProcess("foo");
        process.execute((ShellProcessContext)respCtx);
        AsyncShellTestCase.assertEquals((Object)Status.EVALUATING, (Object)asyncShell.getStatus());
        AsyncShellTestCase.assertEquals((int)0, (int)cancelled.get());
        int r = status.get();
        while (r == 0) {
            r = status.get();
        }
        AsyncShellTestCase.assertEquals((int)1, (int)r);
        AsyncShellTestCase.assertEquals((Object)Status.EVALUATING, (Object)asyncShell.getStatus());
        AsyncShellTestCase.assertEquals((int)0, (int)cancelled.get());
        process.cancel();
        AsyncShellTestCase.assertEquals((Object)Status.CANCELED, (Object)asyncShell.getStatus());
        AsyncShellTestCase.assertEquals((int)1, (int)cancelled.get());
        process.cancel();
        AsyncShellTestCase.assertEquals((Object)Status.CANCELED, (Object)asyncShell.getStatus());
        AsyncShellTestCase.assertEquals((int)1, (int)cancelled.get());
        status.set(2);
        r = status.get();
        while (r == 2) {
            r = status.get();
        }
        AsyncShellTestCase.assertEquals((int)3, (int)r);
        respCtx.getResponse();
        AsyncShellTestCase.assertEquals((Object)Status.AVAILABLE, (Object)asyncShell.getStatus());
        AsyncShellTestCase.assertEquals((int)1, (int)cancelled.get());
        AsyncShellTestCase.assertFalse((boolean)fail.get());
    }

    public void testAsyncEvaluation() throws InterruptedException {
        AsyncShell connector = new AsyncShell(this.executor, (Shell)this.builder.build());
        status = 0;
        SyncShellResponseContext respCtx = new SyncShellResponseContext();
        connector.createProcess("invoke " + AsyncShellTestCase.class.getName() + " bilto").execute((ShellProcessContext)respCtx);
        ShellResponse resp = respCtx.getResponse();
        AsyncShellTestCase.assertTrue((String)("Was not expecting response to be " + resp.getText()), (boolean)(resp instanceof ShellResponse.Ok));
        AsyncShellTestCase.assertEquals((int)1, (int)status);
        respCtx.getResponse();
    }

    public static void bilto() {
        status = status == 0 ? 1 : -1;
    }
}

