/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.console;

import java.io.IOException;
import junit.framework.TestCase;
import org.crsh.term.console.Console;
import org.crsh.term.console.TestClientOutput;
import org.crsh.term.console.ViewWriter;

public abstract class AbstractConsoleTestCase
extends TestCase {
    private TestClientOutput client;
    private Console console;

    protected abstract boolean getSupportsCursorMove();

    private static void assertEquals(CharSequence expected, CharSequence actual) {
        AbstractConsoleTestCase.assertEquals((String)((Object)expected).toString(), (String)((Object)actual).toString());
    }

    protected void setUp() throws Exception {
        this.resetConsole();
    }

    private void resetConsole() {
        this.client = new TestClientOutput(this.getSupportsCursorMove());
        this.console = new Console((ViewWriter)this.client);
    }

    public void testWriterCRLF() throws IOException {
        Console console;
        TestClientOutput output;
        for (String test : new String[]{"a\n", "a\r", "a\r\n"}) {
            output = new TestClientOutput(this.getSupportsCursorMove());
            console = new Console((ViewWriter)output);
            console.getWriter().write((CharSequence)test);
            output.assertChars("a\r\n");
            output.assertEmpty();
        }
        for (String test : new String[]{"a\n\n", "a\n\r", "a\r\r"}) {
            output = new TestClientOutput(this.getSupportsCursorMove());
            console = new Console((ViewWriter)output);
            console.getWriter().write((CharSequence)test);
            output.assertChars("a\r\n\r\n");
            output.assertEmpty();
        }
    }

    public void testNoCR() throws IOException {
        this.console.getViewReader().write((CharSequence)"a");
        AbstractConsoleTestCase.assertFalse((boolean)this.console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals((int)1, (int)this.console.getReader().getSize());
    }

    public void testReadLine() throws IOException {
        for (String test : new String[]{"a\n", "a\r", "a\r\n"}) {
            this.resetConsole();
            this.console.getViewReader().write((CharSequence)test);
            AbstractConsoleTestCase.assertTrue((boolean)this.console.getReader().hasNext());
            AbstractConsoleTestCase.assertEquals("a", this.console.getReader().next());
            AbstractConsoleTestCase.assertFalse((boolean)this.console.getReader().hasNext());
            AbstractConsoleTestCase.assertEquals((int)0, (int)this.console.getReader().getSize());
        }
        for (String test : new String[]{"a\n\n", "a\n\r", "a\r\r"}) {
            this.resetConsole();
            this.console.getViewReader().write((CharSequence)test);
            AbstractConsoleTestCase.assertTrue((boolean)this.console.getReader().hasNext());
            AbstractConsoleTestCase.assertEquals("a", this.console.getReader().next());
            AbstractConsoleTestCase.assertEquals("", this.console.getReader().next());
            AbstractConsoleTestCase.assertFalse((boolean)this.console.getReader().hasNext());
            AbstractConsoleTestCase.assertEquals((int)0, (int)this.console.getReader().getSize());
        }
    }

    public void testErase() throws IOException {
        this.resetConsole();
        this.console.getViewReader().write((CharSequence)"a");
        this.console.getViewReader().del();
        this.console.getViewReader().write((CharSequence)"b\n");
        AbstractConsoleTestCase.assertTrue((boolean)this.console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals("b", this.console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)this.console.getReader().hasNext());
    }

    public void testMoveLeftInsert() throws IOException {
        this.resetConsole();
        this.console.getViewReader().write((CharSequence)"a");
        this.console.getViewReader().moveLeft();
        this.console.getViewReader().write((CharSequence)"b\n");
        AbstractConsoleTestCase.assertTrue((boolean)this.console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveLeftInsert(), this.console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)this.console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveLeftInsert();

    public void testMoveLeftDel() throws IOException {
        this.resetConsole();
        this.console.getViewReader().write((CharSequence)"ab");
        int expected = this.console.getViewReader().moveLeft() ? 97 : 98;
        AbstractConsoleTestCase.assertEquals((int)expected, (int)this.console.getViewReader().del());
        if (this.getSupportsCursorMove()) {
            this.client.assertChars("b ");
            this.client.assertEmpty();
        } else {
            this.client.assertChars("a");
            this.client.assertEmpty();
        }
        this.console.getViewReader().write((CharSequence)"\n");
        AbstractConsoleTestCase.assertTrue((boolean)this.console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveLeftDel(), this.console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)this.console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveLeftDel();

    public void testMoveRightInsert() throws IOException {
        this.resetConsole();
        this.console.getViewReader().write((CharSequence)"abc");
        this.console.getViewReader().moveLeft();
        this.console.getViewReader().moveLeft();
        this.console.getViewReader().moveRight();
        this.console.getViewReader().write((CharSequence)"d\n");
        AbstractConsoleTestCase.assertTrue((boolean)this.console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveRightInsert(), this.console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)this.console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveRightInsert();

    public void testMoveRightDel() throws IOException {
        this.resetConsole();
        this.console.getViewReader().write((CharSequence)"abc");
        this.console.getViewReader().moveLeft();
        this.console.getViewReader().moveLeft();
        this.console.getViewReader().moveRight();
        this.console.getViewReader().del();
        this.console.getViewReader().write((CharSequence)"\n");
        AbstractConsoleTestCase.assertTrue((boolean)this.console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveRightDel(), this.console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)this.console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveRightDel();

    public void testMoveRightAtEndOfLine() throws IOException {
        this.resetConsole();
        this.console.getViewReader().write((CharSequence)"a");
        this.console.getViewReader().moveRight();
        this.console.getViewReader().write((CharSequence)"b\n");
        AbstractConsoleTestCase.assertTrue((boolean)this.console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveRightAtEndOfLine(), this.console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)this.console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveRightAtEndOfLine();

    public void testMoveLeftAtBeginningOfLine() throws IOException {
        this.resetConsole();
        this.console.getViewReader().write((CharSequence)"a");
        this.console.getViewReader().moveLeft();
        this.console.getViewReader().moveLeft();
        this.console.getViewReader().write((CharSequence)"b\n");
        AbstractConsoleTestCase.assertTrue((boolean)this.console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveLeftAtBeginningOfLine(), this.console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)this.console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveLeftAtBeginningOfLine();

    public void testClearBuffer() throws Exception {
        this.resetConsole();
        this.console.getViewReader().write((CharSequence)"a");
        this.console.clearBuffer();
        AbstractConsoleTestCase.assertFalse((boolean)this.console.getReader().hasNext());
        this.console.getViewReader().write((CharSequence)"b\n");
        AbstractConsoleTestCase.assertEquals("b", this.console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)this.console.getReader().hasNext());
    }
}

