/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term;

import java.io.IOException;
import java.util.LinkedList;
import org.crsh.term.CodeType;
import org.crsh.term.Term;
import org.crsh.term.TermEvent;
import org.crsh.term.console.Console;
import org.crsh.term.console.ViewWriter;
import org.crsh.term.spi.TermIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseTerm
implements Term {
    private final Logger log = LoggerFactory.getLogger(BaseTerm.class);
    private final LinkedList<CharSequence> history = new LinkedList();
    private CharSequence historyBuffer = null;
    private int historyCursor = -1;
    private final TermIO io;
    private final Console console;

    public BaseTerm(final TermIO io) {
        this.io = io;
        this.console = new Console(new ViewWriter(){

            protected void flush() throws IOException {
                io.flush();
            }

            protected void writeCRLF() throws IOException {
                io.writeCRLF();
            }

            protected void write(CharSequence s) throws IOException {
                io.write(((Object)s).toString());
            }

            protected void write(char c) throws IOException {
                io.write(c);
            }

            protected void writeDel() throws IOException {
                io.writeDel();
            }

            protected boolean writeMoveLeft() throws IOException {
                return io.moveLeft();
            }

            protected boolean writeMoveRight(char c) throws IOException {
                return io.moveRight(c);
            }
        });
    }

    public int getWidth() {
        return this.io.getWidth();
    }

    public String getProperty(String name) {
        return this.io.getProperty(name);
    }

    public void setEcho(boolean echo) {
        this.console.setEchoing(echo);
    }

    public TermEvent read() throws IOException {
        block10: do {
            int code = this.io.read();
            CodeType type = this.io.decode(code);
            switch (type) {
                case CLOSE: {
                    return new TermEvent.Close();
                }
                case BACKSPACE: {
                    this.console.getViewReader().del();
                    break;
                }
                case UP: 
                case DOWN: {
                    CharSequence s;
                    int nextHistoryCursor = this.historyCursor + (type == CodeType.UP ? 1 : -1);
                    if (nextHistoryCursor < -1 || nextHistoryCursor >= this.history.size()) continue block10;
                    CharSequence charSequence = s = nextHistoryCursor == -1 ? this.historyBuffer : this.history.get(nextHistoryCursor);
                    while (this.console.getViewReader().moveRight()) {
                    }
                    CharSequence t = this.console.getViewReader().replace(s);
                    if (this.historyCursor == -1) {
                        this.historyBuffer = t;
                    }
                    if (nextHistoryCursor == -1) {
                        this.historyBuffer = null;
                    }
                    this.historyCursor = nextHistoryCursor;
                    break;
                }
                case RIGHT: {
                    this.console.getViewReader().moveRight();
                    break;
                }
                case LEFT: {
                    this.console.getViewReader().moveLeft();
                    break;
                }
                case BREAK: {
                    this.log.debug("Want to cancel evaluation");
                    this.console.clearBuffer();
                    return new TermEvent.Break();
                }
                case CHAR: {
                    if (code >= 0 && code < 128) {
                        this.console.getViewReader().write((char)code);
                        break;
                    }
                    this.log.debug("Unhandled char " + code);
                    break;
                }
                case TAB: {
                    this.log.debug("Tab");
                    return new TermEvent.Complete(this.console.getBufferToCursor());
                }
            }
        } while (!this.console.getReader().hasNext());
        this.historyCursor = -1;
        this.historyBuffer = null;
        CharSequence input = this.console.getReader().next();
        return new TermEvent.ReadLine(input);
    }

    public void bufferInsert(CharSequence msg) throws IOException {
        this.console.getViewReader().write(msg);
    }

    public void addToHistory(CharSequence line) {
        this.history.addFirst(line);
    }

    public CharSequence getBuffer() {
        return this.console.getBufferToCursor();
    }

    public void close() {
        try {
            this.log.debug("Closing connection");
            this.io.flush();
            this.io.close();
        }
        catch (IOException e) {
            this.log.debug("Exception thrown during term close()", (Throwable)e);
        }
    }

    public void write(CharSequence msg) throws IOException {
        this.console.getWriter().write(msg);
    }
}

