/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.SimpleValueType;
import org.crsh.cmdline.spi.Completer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumCompleter
implements Completer {
    private static final EnumCompleter instance = new EnumCompleter();

    public static EnumCompleter getInstance() {
        return instance;
    }

    @Override
    public Map<String, Boolean> complete(ParameterDescriptor<?> parameter, String prefix) throws Exception {
        Map<String, Boolean> completions = Collections.emptyMap();
        if (parameter.getType() == SimpleValueType.ENUM) {
            Enum[] values;
            Class<?> vt = parameter.getJavaValueType();
            Method valuesM = vt.getDeclaredMethod("values", new Class[0]);
            Method nameM = vt.getMethod("name", new Class[0]);
            for (Enum value : values = (Enum[])valuesM.invoke(null, new Object[0])) {
                String name = (String)nameM.invoke((Object)value, new Object[0]);
                if (!name.startsWith(prefix)) continue;
                if (completions.isEmpty()) {
                    completions = new HashMap<String, Boolean>();
                }
                completions.put(name.substring(prefix.length()), true);
            }
        }
        return completions;
    }
}

