/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.CRaSHSession;

abstract class CRaSHProcess
implements ShellProcess {
    protected final CRaSHSession crash;
    protected final String request;
    private volatile Thread thread;

    protected CRaSHProcess(CRaSHSession crash, String request) {
        this.crash = crash;
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ShellProcessContext processContext) {
        ShellResponse resp;
        this.thread = Thread.currentThread();
        try {
            resp = this.invoke(processContext);
            if (Thread.interrupted()) {
                throw new InterruptedException("Just a mere goto :-)");
            }
        }
        catch (InterruptedException e) {
            resp = new ShellResponse.Cancelled();
        }
        catch (Throwable t) {
            resp = ShellResponse.internalError(t);
        }
        finally {
            this.thread = null;
        }
        processContext.end(resp);
        if (resp instanceof ShellResponse.Error) {
            ShellResponse.Error error = (ShellResponse.Error)resp;
            Throwable t = error.getThrowable();
            if (t != null) {
                CRaSHSession.log.error("Error while evaluating request '" + this.request + "' " + error.getText(), t);
            } else {
                CRaSHSession.log.error("Error while evaluating request '" + this.request + "' " + error.getText());
            }
        }
    }

    abstract ShellResponse invoke(ShellProcessContext var1) throws InterruptedException;

    public void cancel() {
        Thread t = this.thread;
        if (t != null) {
            t.interrupt();
        }
    }
}

