/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.console;

import java.io.IOException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.crsh.term.console.ConsoleReader;
import org.crsh.term.console.ConsoleWriter;
import org.crsh.term.console.ViewReader;
import org.crsh.term.console.ViewWriter;

public final class Console {
    private char[] buffer;
    private int size = 0;
    private int curAt = 0;
    private LinkedList<CharSequence> lines;
    private boolean previousCR = false;
    private boolean echoing = true;
    private final ViewWriter viewWriter;
    private final ViewReader viewReader = new ViewReader(){

        public CharSequence replace(CharSequence s) throws IOException {
            StringBuilder builder = new StringBuilder();
            boolean flush = false;
            int i = Console.this.appendDel();
            while (i != -1) {
                builder.append((char)i);
                flush = true;
                i = Console.this.appendDel();
            }
            if (flush |= Console.this.appendData(s)) {
                Console.this.viewWriter.flush();
            }
            return builder.reverse().toString();
        }

        public void write(char c) throws IOException {
            if (Console.this.appendData(c)) {
                Console.this.viewWriter.flush();
            }
        }

        public void write(CharSequence s) throws IOException {
            if (Console.this.appendData(((Object)s).toString())) {
                Console.this.viewWriter.flush();
            }
        }

        public int del() throws IOException {
            int ret = Console.this.appendDel();
            if (ret != -1) {
                Console.this.viewWriter.flush();
            }
            return ret;
        }

        public boolean moveRight() throws IOException {
            return Console.this.moveRight();
        }

        public boolean moveLeft() throws IOException {
            return Console.this.moveLeft();
        }
    };
    private final ConsoleReader reader = new ConsoleReader(){

        public int getSize() {
            return Console.this.size;
        }

        public boolean hasNext() {
            return Console.this.lines.size() > 0;
        }

        public CharSequence next() {
            if (Console.this.lines.size() > 0) {
                return (CharSequence)Console.this.lines.removeFirst();
            }
            throw new NoSuchElementException();
        }
    };
    private final ConsoleWriter writer = new ConsoleWriter(){
        private boolean previousCR;

        public void write(CharSequence s) throws IOException {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                this.writeNoFlush(c);
            }
            Console.this.viewWriter.flush();
        }

        public void write(char c) throws IOException {
            this.writeNoFlush(c);
            Console.this.viewWriter.flush();
        }

        private void writeNoFlush(char c) throws IOException {
            if (this.previousCR && c == '\n') {
                this.previousCR = false;
            } else if (c == '\r' || c == '\n') {
                this.previousCR = c == '\r';
                Console.this.viewWriter.writeCRLF();
            } else {
                Console.this.viewWriter.write(c);
            }
        }
    };

    public Console(ViewWriter viewWriter) {
        this.buffer = new char[128];
        this.lines = new LinkedList();
        this.viewWriter = viewWriter;
    }

    public void clearBuffer() {
        this.previousCR = false;
        this.curAt = 0;
        this.size = 0;
    }

    public CharSequence getBuffer() {
        return new String(this.buffer, 0, this.size);
    }

    public CharSequence getBufferToCursor() {
        return new String(this.buffer, 0, this.curAt);
    }

    public boolean isEchoing() {
        return this.echoing;
    }

    public void setEchoing(boolean echoing) {
        this.echoing = echoing;
    }

    public ConsoleReader getReader() {
        return this.reader;
    }

    public ViewReader getViewReader() {
        return this.viewReader;
    }

    public ConsoleWriter getWriter() {
        return this.writer;
    }

    private boolean appendData(CharSequence s) throws IOException {
        boolean flush = false;
        for (int i = 0; i < s.length(); ++i) {
            flush |= this.appendData(s.charAt(i));
        }
        return flush;
    }

    private boolean appendData(char c) throws IOException {
        if (this.previousCR && c == '\n') {
            this.previousCR = false;
            return false;
        }
        if (c == '\r' || c == '\n') {
            this.previousCR = c == '\r';
            String line = new String(this.buffer, 0, this.size);
            this.lines.add(line);
            this.curAt = this.size = 0;
            return this.echoCRLF();
        }
        if (this.push(c)) {
            return this.echo(c);
        }
        String disp = new String(this.buffer, this.curAt, this.size - this.curAt);
        this.viewWriter.write(disp);
        ++this.curAt;
        for (int amount = this.size - this.curAt - 1; amount > 0; --amount) {
            this.viewWriter.writeMoveLeft();
        }
        return true;
    }

    private int appendDel() throws IOException {
        if (this.curAt == this.size) {
            int popped = this.pop();
            if (popped != -1) {
                this.echoDel();
            }
            return popped;
        }
        int popped = this.pop();
        if (popped != -1) {
            if (this.viewWriter.writeMoveLeft()) {
                StringBuilder disp = new StringBuilder();
                disp.append(this.buffer, this.curAt, this.size - this.curAt);
                disp.append(' ');
                this.viewWriter.write(disp);
                for (int amount = this.size - this.curAt + 1; amount > 0; --amount) {
                    this.viewWriter.writeMoveLeft();
                }
            } else {
                throw new UnsupportedOperationException("not implemented");
            }
        }
        return popped;
    }

    private boolean moveRight() throws IOException {
        if (this.curAt < this.size && this.viewWriter.writeMoveRight(this.buffer[this.curAt])) {
            this.viewWriter.flush();
            ++this.curAt;
            return true;
        }
        return false;
    }

    private boolean moveLeft() throws IOException {
        boolean moved;
        boolean bl = moved = this.curAt > 0 && this.viewWriter.writeMoveLeft();
        if (moved) {
            this.viewWriter.flush();
            --this.curAt;
        }
        return moved;
    }

    private boolean echo(char c) throws IOException {
        if (this.echoing) {
            this.viewWriter.write(c);
            return true;
        }
        return false;
    }

    private void echo(String s) throws IOException {
        if (this.echoing) {
            this.viewWriter.write(s);
            this.viewWriter.flush();
        }
    }

    private boolean echoDel() throws IOException {
        if (this.echoing) {
            this.viewWriter.writeDel();
            return true;
        }
        return false;
    }

    private boolean echoCRLF() throws IOException {
        if (this.echoing) {
            this.viewWriter.writeCRLF();
            return true;
        }
        return false;
    }

    private int pop() {
        if (this.curAt > 0) {
            char popped = this.buffer[this.curAt - 1];
            if (this.curAt == this.size) {
                this.buffer[this.curAt] = '\u0000';
                this.size = --this.curAt;
                return popped;
            }
            for (int i = this.curAt; i < this.size; ++i) {
                this.buffer[i - 1] = this.buffer[i];
            }
            this.buffer[--this.size] = '\u0000';
            --this.curAt;
            return popped;
        }
        return -1;
    }

    private boolean push(char c) {
        if (this.size >= this.buffer.length) {
            char[] tmp = new char[this.buffer.length * 2 + 1];
            System.arraycopy(this.buffer, 0, tmp, 0, this.buffer.length);
            this.buffer = tmp;
        }
        if (this.curAt == this.size) {
            this.buffer[this.size++] = c;
            ++this.curAt;
            return true;
        }
        for (int i = this.size - 1; i > this.curAt - 1; --i) {
            this.buffer[i + 1] = this.buffer[i];
        }
        this.buffer[this.curAt] = c;
        ++this.size;
        return false;
    }
}

