/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import groovy.lang.GroovyShell;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.crsh.BaseProcessContext;
import org.crsh.TestPluginLifeCycle;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.CRaSHSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommandTestCase
extends TestCase {
    private final CRaSHPlugin[] NO_PLUGINS = new CRaSHPlugin[0];
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected CRaSHSession shell;
    protected GroovyShell groovyShell;

    protected AbstractCommandTestCase() {
    }

    protected AbstractCommandTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestPluginLifeCycle builder = new TestPluginLifeCycle(this.NO_PLUGINS);
        builder.start();
        this.shell = builder.createShell();
        this.groovyShell = this.shell.getGroovyShell();
    }

    protected void tearDown() throws Exception {
        if (this.shell != null) {
            this.shell.close();
            this.shell = null;
            this.groovyShell = null;
        }
    }

    protected final BaseProcessContext create(String s) {
        return BaseProcessContext.create((Shell)this.shell, s);
    }

    protected final BaseProcessContext execute(String s) {
        return this.create(s).execute();
    }

    protected final ShellResponse evaluate(String s) {
        return this.execute(s).getResponse();
    }

    protected final void assertUnknownCommand(String s) {
        ShellResponse resp = this.evaluate(s);
        AbstractCommandTestCase.assertTrue((String)("Was expecting an ok response instead of " + resp), (boolean)(resp instanceof ShellResponse.UnknownCommand));
        AbstractCommandTestCase.assertEquals((String)s, (String)((ShellResponse.UnknownCommand)resp).getName());
    }

    protected final void assertError(String s, Class<? extends Throwable> expectedErrorType) {
        Throwable error = this.assertError(s);
        if (!expectedErrorType.isInstance(error)) {
            AbstractCommandTestCase.fail((String)("Expected error " + error + " to be of type " + expectedErrorType.getName()));
        }
    }

    protected final Throwable assertError(String s) {
        ShellResponse resp = this.evaluate(s);
        AbstractCommandTestCase.assertTrue((String)("Was expecting an ok response instead of " + resp), (boolean)(resp instanceof ShellResponse.Error));
        return ((ShellResponse.Error)resp).getThrowable();
    }

    protected final ShellResponse.Display assertOk(String expected, String s) {
        ShellResponse.Ok ok = this.assertOk(s);
        AbstractCommandTestCase.assertTrue((String)("Was not expecting response to be " + ok), (boolean)(ok instanceof ShellResponse.Display));
        ShellResponse.Display display = (ShellResponse.Display)ok;
        AbstractCommandTestCase.assertEquals((String)expected, (String)display.getText());
        return display;
    }

    protected final ShellResponse.Ok assertOk(String s) {
        ShellResponse resp = this.evaluate(s);
        if (resp instanceof ShellResponse.Ok) {
            return (ShellResponse.Ok)resp;
        }
        if (resp instanceof ShellResponse.Error) {
            ShellResponse.Error err = (ShellResponse.Error)resp;
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause(err.getThrowable());
            throw afe;
        }
        throw new AssertionFailedError("Was expecting an ok response instead of " + resp);
    }
}

