/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.util.concurrent.CountDownLatch;
import org.crsh.BaseProcessContext;
import org.crsh.shell.AbstractCommandTestCase;
import org.crsh.shell.ShellResponse;

public class CancelTestCase
extends AbstractCommandTestCase {
    private static CountDownLatch latch1;
    private static volatile boolean latch2;
    private static volatile Boolean interrupted;

    public void testInterrupt() {
        final BaseProcessContext ctx = this.create("sleep 100");
        Thread t = new Thread(){

            public void run() {
                ctx.execute();
            }
        };
        t.start();
        while (t.getState() == Thread.State.WAITING) {
        }
        ctx.cancel();
        ShellResponse resp = ctx.getResponse();
        CancelTestCase.assertEquals(ShellResponse.Cancelled.class, resp.getClass());
    }

    public void testLoop() throws Exception {
        final BaseProcessContext ctx = this.create("invoke " + CancelTestCase.class.getName() + " testLoopCallback");
        Thread t = new Thread(){

            public void run() {
                ctx.execute();
            }
        };
        latch1 = new CountDownLatch(1);
        latch2 = true;
        interrupted = null;
        t.start();
        latch1.await();
        ctx.cancel();
        latch2 = false;
        ShellResponse resp = ctx.getResponse();
        CancelTestCase.assertEquals(ShellResponse.Cancelled.class, resp.getClass());
        CancelTestCase.assertEquals((Object)Boolean.TRUE, (Object)interrupted);
    }

    public static void testLoopCallback() {
        latch1.countDown();
        while (latch2) {
        }
        interrupted = Thread.currentThread().isInterrupted();
    }
}

