/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.term.CodeType;
import org.crsh.term.IOAction;
import org.crsh.term.IOEvent;
import org.crsh.term.spi.TermIO;
import org.crsh.term.spi.TermIOHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOHandler
extends CRaSHPlugin<TermIOHandler>
implements TermIOHandler {
    private final BlockingQueue<IOEvent> eventQueue = new LinkedBlockingQueue<IOEvent>();
    private final BlockingQueue<IOAction> actionQueue = new LinkedBlockingQueue<IOAction>();

    public TermIOHandler getImplementation() {
        return this;
    }

    public void handle(TermIO io) {
        while (true) {
            IOAction action = null;
            while (action == null) {
                try {
                    action = this.actionQueue.take();
                }
                catch (InterruptedException e) {}
            }
            try {
                if (action instanceof IOAction.Read) {
                    int code = io.read();
                    CodeType codeType = io.decode(code);
                    this.eventQueue.add(new IOEvent.IO(code, codeType));
                    continue;
                }
                if (action instanceof IOAction.Write) {
                    IOAction.Write write = (IOAction.Write)action;
                    io.write(write.s);
                    continue;
                }
                if (action instanceof IOAction.Close) {
                    io.close();
                    continue;
                }
                if (action instanceof IOAction.Flush) {
                    io.flush();
                    continue;
                }
                if (action instanceof IOAction.CRLF) {
                    io.writeCRLF();
                    continue;
                }
                if (action instanceof IOAction.Del) {
                    io.writeDel();
                    continue;
                }
                if (action instanceof IOAction.Left) {
                    io.moveLeft();
                    continue;
                }
                if (!(action instanceof IOAction.End)) {
                    throw new UnsupportedOperationException("Unexpected action " + action);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.eventQueue.add(new IOEvent.Error(e));
                continue;
            }
            break;
        }
    }

    public IOHandler add(IOAction action) {
        this.actionQueue.add(action);
        return this;
    }

    public int getActionCount() {
        return this.actionQueue.size();
    }

    public void assertEvent(IOEvent expectedEvent) {
        try {
            IOEvent event = this.eventQueue.poll(2L, TimeUnit.SECONDS);
            expectedEvent.assertEquals(event);
        }
        catch (InterruptedException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    public IOEvent take() {
        try {
            return this.eventQueue.take();
        }
        catch (InterruptedException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    public IOEvent poll() {
        return (IOEvent)this.eventQueue.poll();
    }

    public IOEvent peek() {
        return (IOEvent)this.eventQueue.peek();
    }
}

