/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.spi.net;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import junit.framework.TestCase;
import org.crsh.term.CodeType;
import org.crsh.term.spi.net.TermIOClient;

public class TermIOClientTestCase
extends TestCase {
    public void testFoo() throws Exception {
        int i;
        ServerSocket socketServer = new ServerSocket();
        socketServer.bind(new InetSocketAddress(0));
        int port = socketServer.getLocalPort();
        System.out.println("Bound on port " + port);
        TermIOClient client = new TermIOClient(port);
        client.connect();
        Socket serverSocket = socketServer.accept();
        OutputStream out = serverSocket.getOutputStream();
        InputStream in = serverSocket.getInputStream();
        out.write(new byte[]{(byte)CodeType.CHAR.ordinal(), 0, 97});
        out.flush();
        int r = client.read();
        TermIOClientTestCase.assertEquals((Object)CodeType.CHAR, (Object)client.decode(r));
        TermIOClientTestCase.assertEquals((int)97, (int)r);
        TermIOClientTestCase.assertEquals((int)0, (int)in.read());
        out.write(CodeType.BACKSPACE.ordinal());
        out.flush();
        TermIOClientTestCase.assertEquals((Object)CodeType.BACKSPACE, (Object)client.decode(client.read()));
        TermIOClientTestCase.assertEquals((int)0, (int)in.read());
        client.write('b');
        client.flush();
        TermIOClientTestCase.assertEquals((int)1, (int)in.read());
        TermIOClientTestCase.assertEquals((int)0, (int)in.read());
        TermIOClientTestCase.assertEquals((int)98, (int)in.read());
        TermIOClientTestCase.assertEquals((int)7, (int)in.read());
        client.write("ab");
        client.flush();
        TermIOClientTestCase.assertEquals((int)2, (int)in.read());
        TermIOClientTestCase.assertEquals((int)0, (int)in.read());
        TermIOClientTestCase.assertEquals((int)0, (int)in.read());
        TermIOClientTestCase.assertEquals((int)97, (int)in.read());
        TermIOClientTestCase.assertEquals((int)0, (int)in.read());
        TermIOClientTestCase.assertEquals((int)98, (int)in.read());
        TermIOClientTestCase.assertEquals((int)7, (int)in.read());
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 258; ++i) {
            sb.append('a');
        }
        client.write(sb.toString());
        client.flush();
        TermIOClientTestCase.assertEquals((int)2, (int)in.read());
        TermIOClientTestCase.assertEquals((int)255, (int)in.read());
        for (i = 0; i < 257; ++i) {
            TermIOClientTestCase.assertEquals((int)0, (int)in.read());
            TermIOClientTestCase.assertEquals((int)97, (int)in.read());
        }
        TermIOClientTestCase.assertEquals((int)1, (int)in.read());
        TermIOClientTestCase.assertEquals((int)0, (int)in.read());
        TermIOClientTestCase.assertEquals((int)97, (int)in.read());
        TermIOClientTestCase.assertEquals((int)7, (int)in.read());
        client.writeDel();
        client.flush();
        TermIOClientTestCase.assertEquals((int)3, (int)in.read());
        TermIOClientTestCase.assertEquals((int)7, (int)in.read());
        client.writeCRLF();
        client.flush();
        TermIOClientTestCase.assertEquals((int)4, (int)in.read());
        TermIOClientTestCase.assertEquals((int)7, (int)in.read());
        TermIOClientTestCase.assertTrue((boolean)client.moveRight('d'));
        client.flush();
        TermIOClientTestCase.assertEquals((int)5, (int)in.read());
        TermIOClientTestCase.assertEquals((int)0, (int)in.read());
        TermIOClientTestCase.assertEquals((int)100, (int)in.read());
        TermIOClientTestCase.assertEquals((int)7, (int)in.read());
        TermIOClientTestCase.assertTrue((boolean)client.moveLeft());
        client.flush();
        TermIOClientTestCase.assertEquals((int)6, (int)in.read());
        TermIOClientTestCase.assertEquals((int)7, (int)in.read());
        TermIOClientTestCase.assertEquals(null, (String)client.getProperty(""));
        out.write(0);
        TermIOClientTestCase.assertEquals(null, (String)client.getProperty("a"));
        TermIOClientTestCase.assertEquals((int)8, (int)in.read());
        TermIOClientTestCase.assertEquals((int)0, (int)in.read());
        TermIOClientTestCase.assertEquals((int)97, (int)in.read());
        out.write(1);
        TermIOClientTestCase.assertEquals((String)"", (String)client.getProperty("a"));
        TermIOClientTestCase.assertEquals((int)8, (int)in.read());
        TermIOClientTestCase.assertEquals((int)0, (int)in.read());
        TermIOClientTestCase.assertEquals((int)97, (int)in.read());
        out.write(2);
        out.write(98);
        TermIOClientTestCase.assertEquals((String)"b", (String)client.getProperty("a"));
        TermIOClientTestCase.assertEquals((int)8, (int)in.read());
        TermIOClientTestCase.assertEquals((int)0, (int)in.read());
        TermIOClientTestCase.assertEquals((int)97, (int)in.read());
        out.write(3);
        out.write(51);
        out.write(50);
        TermIOClientTestCase.assertEquals((int)32, (int)client.getWidth());
        TermIOClientTestCase.assertEquals((int)8, (int)in.read());
        TermIOClientTestCase.assertEquals((int)4, (int)in.read());
        TermIOClientTestCase.assertEquals((int)119, (int)in.read());
        TermIOClientTestCase.assertEquals((int)105, (int)in.read());
        TermIOClientTestCase.assertEquals((int)100, (int)in.read());
        TermIOClientTestCase.assertEquals((int)116, (int)in.read());
        TermIOClientTestCase.assertEquals((int)104, (int)in.read());
    }
}

