/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.io.IOException;
import java.io.StringWriter;
import junit.framework.TestCase;
import org.crsh.shell.io.ShellWriterContext;
import org.crsh.util.LineFeedWriter;

public class LineFeedWriterTestCase
extends TestCase {
    private String padding;

    private void assertWriter(String expected, String ... texts) throws Exception {
        StringWriter buffer = new StringWriter();
        LineFeedWriter writer = new LineFeedWriter((Appendable)buffer, "_");
        ShellWriterContext ctx = new ShellWriterContext(){

            public void pad(Appendable appendable) throws IOException {
                if (LineFeedWriterTestCase.this.padding != null) {
                    appendable.append(LineFeedWriterTestCase.this.padding);
                }
            }

            public void text(CharSequence csq, int off, int end) {
            }

            public void lineFeed() {
            }
        };
        for (String text : texts) {
            writer.append(ctx, (CharSequence)text);
        }
        LineFeedWriterTestCase.assertEquals((String)expected, (String)buffer.toString());
    }

    public void testFoo1() throws Exception {
        this.assertWriter("", "");
    }

    public void testFoo2() throws Exception {
        this.assertWriter("a", "a");
    }

    public void testFoo3() throws Exception {
        this.assertWriter("_", "\n");
        this.assertWriter("_", "\r\n");
        this.assertWriter("_", "\r", "\n");
        this.assertWriter("_", "\r", "\r", "\n");
    }

    public void testFoo4() throws Exception {
        this.assertWriter("a_", "a\n");
    }

    public void testFoo5() throws Exception {
        this.assertWriter("_a", "\na");
    }

    public void testFoo6() throws Exception {
        this.assertWriter("a_b", "a\nb");
    }

    public void testFoo7() throws Exception {
        this.assertWriter("ab", "a\rb");
    }

    public void testFoo8() throws Exception {
        this.assertWriter("", "\r");
    }

    public void testPadding1() throws Exception {
        this.padding = "-";
        this.assertWriter("-a", "a");
    }

    public void testPadding2() throws Exception {
        this.padding = "-";
        this.assertWriter("-a_", "a\n");
    }

    public void testPadding3() throws Exception {
        this.padding = "-";
        this.assertWriter("-a_-b", "a\nb");
    }
}

