/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import junit.framework.TestCase;
import org.crsh.util.IO;
import org.crsh.vfs.FS;
import org.crsh.vfs.File;
import org.crsh.vfs.Path;
import org.crsh.vfs.spi.jarurl.Handle;
import org.crsh.vfs.spi.jarurl.JarURLDriver;

public class FSTestCase
extends TestCase {
    public void testFoo() throws Exception {
        FS fs = new FS().mount(FSTestCase.class);
        File root = fs.get(Path.get((String)"/"));
        File org = root.child("org", true);
        FSTestCase.assertEquals((String)"org", (String)org.getName());
        FSTestCase.assertEquals((boolean)true, (boolean)org.isDir());
        Iterator orgChildren = org.children().iterator();
        File crsh = (File)orgChildren.next();
        FSTestCase.assertFalse((boolean)orgChildren.hasNext());
        FSTestCase.assertEquals((String)"crsh", (String)crsh.getName());
        FSTestCase.assertEquals((boolean)true, (boolean)crsh.isDir());
    }

    public void testJar() throws Exception {
        int pos;
        java.io.File file = java.io.File.createTempFile("test", ".jar");
        file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(file);
        JarOutputStream jos = new JarOutputStream(out);
        String name = FSTestCase.class.getName().replace('.', '/') + ".class";
        JarEntry entry = new JarEntry(name);
        int prev = 0;
        while ((pos = name.indexOf(47, prev)) != -1) {
            prev = pos + 1;
            jos.putNextEntry(new JarEntry(name.substring(0, prev)));
            jos.closeEntry();
        }
        jos.putNextEntry(entry);
        InputStream classStream = FSTestCase.class.getClassLoader().getResourceAsStream(name);
        IO.copy((InputStream)classStream, (OutputStream)jos);
        jos.closeEntry();
        jos.close();
        URLClassLoader cl = new URLClassLoader(new URL[]{file.toURI().toURL()});
        URL classURL = cl.findResource(FSTestCase.class.getName().replace('.', '/') + ".class");
        JarURLConnection conn = (JarURLConnection)classURL.openConnection();
        JarURLDriver driver = new JarURLDriver(conn);
        Handle root = driver.root();
        FSTestCase.assertEquals((String)"", (String)driver.name(root));
        FSTestCase.assertTrue((boolean)driver.isDir(root));
        Iterator rootChildren = driver.children(root).iterator();
        Handle org = (Handle)rootChildren.next();
        FSTestCase.assertFalse((boolean)rootChildren.hasNext());
        FSTestCase.assertEquals((String)"org", (String)driver.name(org));
        FSTestCase.assertTrue((boolean)driver.isDir(org));
        Iterator orgChildren = driver.children(org).iterator();
        Handle crsh = (Handle)orgChildren.next();
        FSTestCase.assertFalse((boolean)orgChildren.hasNext());
        FSTestCase.assertEquals((String)"crsh", (String)driver.name(crsh));
        FSTestCase.assertTrue((boolean)driver.isDir(crsh));
        Iterator vfsChildren = driver.children(crsh).iterator();
        Handle vfs = (Handle)vfsChildren.next();
        FSTestCase.assertFalse((boolean)vfsChildren.hasNext());
        FSTestCase.assertEquals((String)"vfs", (String)driver.name(vfs));
        FSTestCase.assertTrue((boolean)driver.isDir(vfs));
        Iterator clazzChildren = driver.children(vfs).iterator();
        Handle clazz = (Handle)clazzChildren.next();
        FSTestCase.assertFalse((boolean)clazzChildren.hasNext());
        FSTestCase.assertEquals((String)(FSTestCase.class.getSimpleName() + ".class"), (String)driver.name(clazz));
        FSTestCase.assertFalse((boolean)driver.isDir(clazz));
        URL clazzURL = driver.toURL(clazz);
        InputStream in = clazzURL.openStream();
        in.close();
    }
}

