/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.command.impl;

import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.crsh.command.InvocationContext;
import org.crsh.command.impl.AttributesMap;
import org.crsh.command.impl.BaseCommandContext;
import org.crsh.shell.io.ShellPrinter;
import org.crsh.util.LineFeedWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseInvocationContext<C, P>
extends BaseCommandContext
implements InvocationContext<C, P> {
    protected ShellPrinter writer = null;
    protected StringWriter buffer = null;
    protected List<P> producedItems;
    protected Iterable<C> consumedItems;

    protected BaseInvocationContext(Iterable<C> consumedItems, Map<String, Object> attributes) {
        super(attributes);
        this.consumedItems = consumedItems;
        this.producedItems = Collections.emptyList();
    }

    @Override
    protected Map<String, Object> attributes(Map<String, Object> attributes) {
        return new AttributesMap(this, attributes);
    }

    public List<P> getProducedItems() {
        return this.producedItems;
    }

    public StringWriter getBuffer() {
        return this.buffer;
    }

    @Override
    public boolean isPiped() {
        return this.consumedItems != null;
    }

    @Override
    public Iterable<C> consume() {
        if (this.consumedItems == null) {
            throw new IllegalStateException("Cannot consume as no pipe operation is involved");
        }
        return this.consumedItems;
    }

    @Override
    public void produce(P product) {
        if (this.producedItems.isEmpty()) {
            this.producedItems = new LinkedList<P>();
        }
        this.producedItems.add(product);
    }

    @Override
    public ShellPrinter getWriter() {
        if (this.writer == null) {
            this.buffer = new StringWriter();
            this.writer = new ShellPrinter(new LineFeedWriter(this.buffer, "\r\n"));
        }
        return this.writer;
    }
}

