/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.crsh.plugin.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyDescriptor<T> {
    private static final Map<String, PropertyDescriptor<?>> INTERNAL_ALL = new HashMap();
    public static final Map<String, PropertyDescriptor<?>> ALL = Collections.unmodifiableMap(INTERNAL_ALL);
    public static final PropertyDescriptor<TimeUnit> VFS_REFRESH_UNIT = new PropertyDescriptor<TimeUnit>(TimeUnit.class, "vfs.refresh_unit", TimeUnit.SECONDS, "The refresh time unit"){

        @Override
        public TimeUnit doParse(String s) {
            return TimeUnit.valueOf(s);
        }
    };
    public static final PropertyDescriptor<Integer> VFS_REFRESH_PERIOD = PropertyDescriptor.create("vfs.refresh_period", (Integer)null, "The refresh rate period");
    public final Class<T> type;
    public final String name;
    public final T defaultValue;
    public final String description;

    public static PropertyDescriptor<String> create(String name, String defaultValue, String description) {
        return new PropertyDescriptor<String>(String.class, name, defaultValue, description){

            @Override
            protected String doParse(String s) throws Exception {
                return s;
            }
        };
    }

    public static PropertyDescriptor<Integer> create(String name, Integer defaultValue, String description) {
        return new PropertyDescriptor<Integer>(Integer.class, name, defaultValue, description){

            @Override
            protected Integer doParse(String s) throws Exception {
                return Integer.parseInt(s);
            }
        };
    }

    protected PropertyDescriptor(Class<T> type, String name, T defaultValue, String description) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("No null type accepted");
        }
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        if (description == null) {
            throw new NullPointerException("No null description accepted");
        }
        this.type = type;
        this.name = name;
        this.defaultValue = defaultValue;
        this.description = description;
        INTERNAL_ALL.put(name, this);
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Class<T> getType() {
        return this.type;
    }

    public final T getDefaultValue() {
        return this.defaultValue;
    }

    public final T parse(String s) throws NullPointerException, IllegalArgumentException {
        if (s == null) {
            throw new NullPointerException("Cannot parse null property values");
        }
        try {
            return this.doParse(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal property value " + s, e);
        }
    }

    public final Property<T> toProperty(String s) throws NullPointerException, IllegalArgumentException {
        T value = this.parse(s);
        return new Property<T>(this, value);
    }

    protected abstract T doParse(String var1) throws Exception;
}

