/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.standalone;

import java.io.Closeable;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.List;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandFactory;
import org.crsh.cmdline.annotations.Argument;
import org.crsh.cmdline.annotations.Command;
import org.crsh.cmdline.annotations.Option;
import org.crsh.cmdline.matcher.CommandMatch;
import org.crsh.cmdline.matcher.InvocationContext;
import org.crsh.cmdline.matcher.Matcher;
import org.crsh.shell.impl.CRaSH;
import org.crsh.standalone.Bootstrap;
import org.crsh.term.BaseTerm;
import org.crsh.term.processor.Processor;
import org.crsh.term.spi.net.TermIOClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agent {
    private static Logger log = LoggerFactory.getLogger(Agent.class);

    public static void agentmain(final String agentArgs, Instrumentation inst) throws Exception {
        log.info("CRaSH agent loaded");
        Thread t = new Thread(){

            public void run() {
                try {
                    ClassDescriptor c = CommandFactory.create(Agent.class);
                    Matcher matcher = Matcher.createMatcher((String)"main", (ClassDescriptor)c);
                    CommandMatch match = matcher.match(agentArgs);
                    match.invoke(new InvocationContext(), (Object)new Agent());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        log.info("Spanned CRaSH thread " + t.getId() + " for further processing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command
    public void main(@Option(names={"j", "jar"}) List<String> jars, @Option(names={"p", "path"}) List<String> paths, @Argument(name="port") Integer port) throws Exception {
        Bootstrap bootstrap = new Bootstrap(Thread.currentThread().getContextClassLoader());
        if (paths != null) {
            for (String path : paths) {
                File mount = new File(path);
                bootstrap.addToMounts(mount);
            }
        }
        if (jars != null) {
            for (String jar : jars) {
                File jarFile = new File(jar);
                bootstrap.addToClassPath(jarFile);
            }
        }
        bootstrap.bootstrap();
        try {
            final TermIOClient client = new TermIOClient(port);
            log.info("Callback back remote on port " + port);
            client.connect();
            BaseTerm term = new BaseTerm(client);
            CRaSH crash = new CRaSH(bootstrap.getContext());
            Processor processor = new Processor(term, crash.createSession());
            processor.addListener(new Closeable(){

                public void close() {
                    client.close();
                }
            });
            processor.run();
        }
        finally {
            bootstrap.shutdown();
        }
    }
}

