/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.standalone;

import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandFactory;
import org.crsh.cmdline.annotations.Argument;
import org.crsh.cmdline.annotations.Command;
import org.crsh.cmdline.annotations.Option;
import org.crsh.cmdline.annotations.Usage;
import org.crsh.cmdline.matcher.CommandMatch;
import org.crsh.cmdline.matcher.InvocationContext;
import org.crsh.cmdline.matcher.Matcher;
import org.crsh.shell.impl.CRaSH;
import org.crsh.standalone.Bootstrap;
import org.crsh.term.BaseTerm;
import org.crsh.term.processor.Processor;
import org.crsh.term.spi.jline.JLineIO;
import org.crsh.term.spi.net.TermIOServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static Logger log = LoggerFactory.getLogger(Main.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command
    public void main(@Option(names={"j", "jar"}) @Usage(value="specify a file system path of a jar added to the class path") List<String> jars, @Option(names={"p", "path"}) @Usage(value="specify a file system path of a dir added to the mount path") List<String> paths, @Argument(name="pid") @Usage(value="the optional JVM process id to attach to") Integer pid) throws Exception {
        if (pid != null) {
            File file;
            URL url = Main.class.getProtectionDomain().getCodeSource().getLocation();
            File f = new File(url.toURI());
            log.info("Attaching to remote process " + pid);
            VirtualMachine vm = VirtualMachine.attach("" + pid);
            TermIOServer server = new TermIOServer(new JLineIO(), 0);
            int port = server.bind();
            log.info("Callback server set on port " + port);
            StringBuilder sb = new StringBuilder();
            if (paths != null) {
                for (String path : paths) {
                    file = new File(path);
                    if (!file.exists()) continue;
                    sb.append("--path ").append(file.getAbsolutePath()).append(' ');
                }
            }
            if (jars != null) {
                for (String jar : jars) {
                    file = new File(jar);
                    if (!file.exists()) continue;
                    sb.append("--jar ").append(file.getAbsolutePath()).append(' ');
                }
            }
            sb.append(port);
            String options = sb.toString();
            log.info("Loading agent with command " + options);
            vm.loadAgent(f.getCanonicalPath(), options);
            try {
                server.accept();
                while (server.execute()) {
                }
            }
            finally {
                vm.detach();
            }
        }
        Bootstrap bootstrap = new Bootstrap(Thread.currentThread().getContextClassLoader());
        if (paths != null) {
            for (String path : paths) {
                File mount = new File(path);
                bootstrap.addToMounts(mount);
            }
        }
        if (jars != null) {
            for (String jar : jars) {
                File jarFile = new File(jar);
                bootstrap.addToClassPath(jarFile);
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
            }
        });
        bootstrap.bootstrap();
        BaseTerm term = new BaseTerm(new JLineIO());
        CRaSH crash = new CRaSH(bootstrap.getContext());
        Processor processor = new Processor(term, crash.createSession());
        try {
            processor.run();
        }
        finally {
            bootstrap.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                line.append(' ');
            }
            line.append(args[i]);
        }
        ClassDescriptor c = CommandFactory.create(Main.class);
        Matcher matcher = Matcher.createMatcher((String)"main", (ClassDescriptor)c);
        CommandMatch match = matcher.match(line.toString());
        match.invoke(new InvocationContext(), (Object)new Main());
    }
}

