/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.processor;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.term.Term;
import org.crsh.term.TermEvent;
import org.crsh.term.processor.Result;
import org.crsh.term.processor.ShellInvoker;
import org.crsh.term.processor.State;
import org.crsh.term.processor.Status;
import org.crsh.term.processor.Task;
import org.crsh.util.FutureListener;
import org.crsh.util.LatchedFuture;
import org.crsh.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Processor
implements Runnable {
    final Logger log = LoggerFactory.getLogger(Processor.class);
    final Term term;
    private final AtomicReference<Status> status;
    private final Shell shell;
    volatile ShellProcess process;
    private final List<Closeable> listeners;

    public Processor(Term term, Shell shell) {
        this.term = term;
        this.status = new AtomicReference<Status>(State.INITIAL.available);
        this.shell = shell;
        this.process = null;
        this.listeners = new ArrayList<Closeable>();
    }

    public void run() {
        Result result;
        State state;
        while ((state = (result = this.execute()).getState()) != State.CLOSED) {
        }
    }

    public boolean isAvailable() {
        return this.process == null;
    }

    public State getState() {
        return this.status.get().getState();
    }

    public Result execute() {
        final Status _status = this.status.get();
        Task task = null;
        if (_status == State.INITIAL.available) {
            task = new Task(){

                @Override
                protected LatchedFuture<State> execute() {
                    try {
                        String welcome = Processor.this.shell.getWelcome();
                        Processor.this.log.debug("Writing welcome message to term");
                        Processor.this.term.write(welcome);
                        Processor.this.log.debug("Wrote welcome message to term");
                        Processor.this.writePrompt();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return new LatchedFuture<State>(State.OPEN);
                }
            };
        } else if (_status == State.OPEN.available) {
            task = new Task(){

                @Override
                protected LatchedFuture<State> execute() {
                    TermEvent event = null;
                    try {
                        Processor.this.log.debug("About to read next term event");
                        event = Processor.this.term.read();
                        Processor.this.log.debug("Read next term event " + event);
                    }
                    catch (IOException e) {
                        if (Processor.this.status.get() == State.OPEN.available) {
                            Processor.this.log.error("Could not read term data", (Throwable)e);
                        }
                        Processor.this.log.debug("Exception but term is considered as closed", (Throwable)e);
                    }
                    if (event == null) {
                        return new LatchedFuture<State>(State.OPEN);
                    }
                    if (event instanceof TermEvent.ReadLine) {
                        String line = ((Object)((TermEvent.ReadLine)event).getLine()).toString();
                        Processor.this.log.debug("Submitting command " + line);
                        ShellInvoker invoker = new ShellInvoker(Processor.this);
                        Processor.this.process = Processor.this.shell.createProcess(((Object)((TermEvent.ReadLine)event).getLine()).toString());
                        Processor.this.process.execute(invoker);
                        if (line.length() > 0) {
                            Processor.this.term.addToHistory(line);
                        }
                        return invoker.result;
                    }
                    if (event instanceof TermEvent.Break) {
                        if (Processor.this.process != null) {
                            Processor.this.process.cancel();
                        } else {
                            Processor.this.log.debug("Ignoring action " + event);
                            Processor.this.writePrompt();
                        }
                        return new LatchedFuture<State>(State.OPEN);
                    }
                    if (event instanceof TermEvent.Complete) {
                        String commonCompletion;
                        TermEvent.Complete complete = (TermEvent.Complete)event;
                        String prefix = ((Object)complete.getLine()).toString();
                        Processor.this.log.debug("About to get completions for " + prefix);
                        Map<String, String> completions = Processor.this.shell.complete(prefix);
                        Processor.this.log.debug("Completions for " + prefix + " are " + completions);
                        if (completions.size() == 0) {
                            commonCompletion = "";
                        } else if (completions.size() == 1) {
                            Map.Entry<String, String> entry = completions.entrySet().iterator().next();
                            commonCompletion = entry.getKey() + entry.getValue();
                        } else {
                            commonCompletion = Strings.findLongestCommonPrefix(completions.keySet());
                        }
                        if (commonCompletion.length() > 0) {
                            try {
                                Processor.this.term.bufferInsert(commonCompletion);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        } else if (completions.size() > 1) {
                            StringBuilder sb = new StringBuilder("\n");
                            Iterator<String> i = completions.keySet().iterator();
                            while (i.hasNext()) {
                                String completion = i.next();
                                sb.append(completion);
                                if (!i.hasNext()) continue;
                                sb.append(" ");
                            }
                            sb.append("\n");
                            try {
                                Processor.this.term.write(sb.toString());
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            Processor.this.writePrompt();
                        }
                        return new LatchedFuture<State>(State.OPEN);
                    }
                    if (event instanceof TermEvent.Close) {
                        return new LatchedFuture<State>(State.WANT_CLOSE);
                    }
                    return new LatchedFuture<State>(State.OPEN);
                }
            };
        } else if (_status == State.WANT_CLOSE.available) {
            task = new Task(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected LatchedFuture<State> execute() {
                    ArrayList listeners;
                    Processor.this.log.debug("Closing processor");
                    List list = Processor.this.listeners;
                    synchronized (list) {
                        listeners = new ArrayList(Processor.this.listeners);
                    }
                    Processor.this.status.set(State.CLOSED.available);
                    for (Closeable listener : listeners) {
                        try {
                            Processor.this.log.debug("Closing " + listener.getClass().getSimpleName());
                            listener.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return new LatchedFuture<State>(State.CLOSED);
                }
            };
        }
        if (task != null) {
            final LatchedFuture<State> futureState = task.execute();
            futureState.addListener(new FutureListener<State>(){

                @Override
                public void completed(State value) {
                    Processor.this.status.set(value.available);
                }
            });
            return new Result(){

                public State getState() {
                    try {
                        return (State)((Object)futureState.get());
                    }
                    catch (InterruptedException e) {
                        return ((Status)Processor.this.status.get()).getState();
                    }
                    catch (ExecutionException e) {
                        return ((Status)Processor.this.status.get()).getState();
                    }
                }
            };
        }
        return new Result(){

            public State getState() {
                return _status.getState();
            }
        };
    }

    void writePrompt() {
        String prompt = this.shell.getPrompt();
        try {
            String p = prompt == null ? "% " : prompt;
            this.term.write("\r\n");
            this.term.write(p);
            this.term.write(this.term.getBuffer());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Closeable listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        List<Closeable> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(listener)) {
                throw new IllegalStateException("Already listening");
            }
            this.listeners.add(listener);
        }
    }
}

