/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.processor;

import java.io.IOException;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.term.TermEvent;
import org.crsh.term.processor.Processor;
import org.crsh.term.processor.State;
import org.crsh.util.LatchedFuture;

class ShellInvoker
implements ShellProcessContext {
    final LatchedFuture<State> result = new LatchedFuture();
    private final Processor processor;

    public ShellInvoker(Processor processor) {
        this.processor = processor;
    }

    public int getWidth() {
        return this.processor.term.getWidth();
    }

    public String getProperty(String name) {
        return this.processor.term.getProperty(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(String msg, boolean echo) {
        try {
            this.processor.term.setEcho(echo);
            this.processor.term.write(msg);
            TermEvent action = this.processor.term.read();
            CharSequence line = null;
            if (action instanceof TermEvent.ReadLine) {
                line = ((TermEvent.ReadLine)action).getLine();
                this.processor.log.debug("Read from console");
            } else {
                this.processor.log.debug("Ignoring action " + action + " returning null");
            }
            this.processor.term.write("\r\n");
            String string = ((Object)line).toString();
            return string;
        }
        catch (Exception e) {
            this.processor.log.error("Reading from console failed", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            this.processor.term.setEcho(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(ShellResponse response) {
        block8: {
            try {
                if (response instanceof ShellResponse.Close) {
                    this.processor.log.debug("received close response");
                    this.result.set(State.WANT_CLOSE);
                    break block8;
                }
                if (response instanceof ShellResponse.Cancelled) {
                    this.result.set(State.OPEN);
                } else {
                    String ret = response.getText();
                    this.processor.log.debug("Command completed with result " + ret);
                    try {
                        this.processor.term.write(ret);
                    }
                    catch (IOException e) {
                        this.processor.log.error("Write to term failure", (Throwable)e);
                    }
                    this.processor.process = null;
                }
                this.processor.writePrompt();
                this.result.set(State.OPEN);
            }
            finally {
                this.processor.process = null;
            }
        }
    }
}

