/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import junit.framework.TestCase;
import org.crsh.BaseProcess;
import org.crsh.BaseProcessContext;
import org.crsh.BaseProcessFactory;
import org.crsh.BaseShell;
import org.crsh.TestPluginLifeCycle;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.concurrent.AsyncProcess;
import org.crsh.shell.concurrent.AsyncShell;
import org.crsh.shell.concurrent.Status;

public class AsyncShellTestCase
extends TestCase {
    protected TestPluginLifeCycle lifeCycle;
    private static volatile int status;

    protected void setUp() throws Exception {
        super.setUp();
        TestPluginLifeCycle lifeCycle = new TestPluginLifeCycle();
        lifeCycle.start();
        this.lifeCycle = lifeCycle;
    }

    public void testReadLine() throws Exception {
        BaseProcessFactory factory = new BaseProcessFactory(){

            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    protected ShellResponse execute(String request) {
                        String a = this.readLine("bar", true);
                        return ShellResponse.display((String)a);
                    }
                };
            }
        };
        BaseShell shell = new BaseShell(factory);
        AsyncShell asyncShell = new AsyncShell((Executor)Executors.newSingleThreadExecutor(), (Shell)shell);
        BaseProcessContext ctx = BaseProcessContext.create((Shell)asyncShell, "foo");
        ctx.addLineInput("juu");
        ctx.execute();
        ShellResponse resp = ctx.getResponse();
        AsyncShellTestCase.assertTrue((boolean)(resp instanceof ShellResponse.Display));
        AsyncShellTestCase.assertEquals((String)"juu", (String)resp.getText());
        ctx.assertLineOutput("bar");
        ctx.assertNoOutput();
        ctx.assertNoInput();
    }

    public void testAsyncEvaluation() throws InterruptedException {
        AsyncShell connector = new AsyncShell((Executor)Executors.newSingleThreadExecutor(), (Shell)this.lifeCycle.createShell());
        status = 0;
        BaseProcessContext ctx = BaseProcessContext.create((Shell)connector, "invoke " + AsyncShellTestCase.class.getName() + " bilto");
        ctx.execute();
        ShellResponse resp = ctx.getResponse();
        AsyncShellTestCase.assertTrue((String)("Was not expecting response to be " + resp.getText()), (boolean)(resp instanceof ShellResponse.Ok));
        AsyncShellTestCase.assertEquals((int)1, (int)status);
        ctx.getResponse();
    }

    public static void bilto() {
        status = status == 0 ? 1 : -1;
    }

    public void testDirect() throws Exception {
        BaseShell shell = new BaseShell(BaseProcessFactory.ECHO);
        AsyncShell asyncShell = new AsyncShell(new Executor(){

            public void execute(Runnable command) {
                command.run();
            }
        }, (Shell)shell);
        BaseProcessContext ctx = BaseProcessContext.create((Shell)asyncShell, "hello").execute();
        AsyncShellTestCase.assertEquals((Object)Status.TERMINATED, (Object)((AsyncProcess)ctx.getProcess()).getStatus());
        AsyncShellTestCase.assertEquals((Object)ShellResponse.display((String)"hello"), (Object)ctx.getResponse());
    }
}

