/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.processor;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.crsh.BaseProcessFactory;
import org.crsh.BaseShell;
import org.crsh.cmdline.CommandCompletion;
import org.crsh.cmdline.Delimiter;
import org.crsh.cmdline.spi.ValueCompletion;
import org.crsh.shell.Shell;
import org.crsh.term.BaseTerm;
import org.crsh.term.Term;
import org.crsh.term.processor.Processor;
import org.crsh.term.spi.TermIO;
import org.crsh.term.spi.TestTermIO;

public class ProcessorTestCase
extends TestCase {
    public void testLine() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.append("abc\r\n");
        controller.connector.assertChars("abc");
        controller.connector.assertCRLF();
        controller.connector.assertChars("abc");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testDel() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.append("abc");
        controller.connector.appendDel();
        controller.connector.append("\r\n");
        controller.connector.assertChars("abc");
        controller.connector.assertDel();
        controller.connector.assertCRLF();
        controller.connector.assertChars("ab");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testBreak() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.append("abc");
        controller.connector.appendBreak();
        controller.connector.assertChars("abc");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.connector.append("def\r\n");
        controller.connector.assertChars("def");
        controller.connector.assertCRLF();
        controller.connector.assertChars("def");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testInsert() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.append("ab");
        controller.connector.appendMoveLeft();
        controller.connector.append("c\r\n");
        controller.connector.assertChars("ab");
        controller.connector.assertMoveLeft();
        controller.connector.assertChars("cb");
        controller.connector.assertMoveLeft();
        controller.connector.assertCRLF();
        controller.connector.assertChars("acb");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testIdempotentMoveRight() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.append("a");
        controller.connector.appendMoveRight();
        controller.connector.append("\r\n");
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testIdempotentMoveLeft() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.appendMoveLeft();
        controller.connector.append("a");
        controller.connector.append("\r\n");
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testMoveUp() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.append("a");
        controller.connector.append("\r\n");
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.connector.appendMoveUp();
        controller.connector.assertChars("a");
        controller.connector.append("\r\n");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testIdempotentMoveUp() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.append("a");
        controller.connector.append("\r\n");
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.connector.appendMoveUp();
        controller.connector.appendMoveUp();
        controller.connector.assertChars("a");
        controller.connector.append("\r\n");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testIdempotentMoveDown() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.append("a");
        controller.connector.append("\r\n");
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.connector.appendMoveDown();
        controller.connector.append("\r\n");
        controller.connector.assertCRLF();
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testCompletion1() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO){

            public CommandCompletion complete(String prefix) {
                return new CommandCompletion(Delimiter.EMPTY, ValueCompletion.create((String)new StringBuilder(prefix).reverse().toString(), (boolean)false));
            }
        });
        controller.assertStart();
        controller.connector.append("ab");
        controller.connector.appendTab();
        controller.connector.assertChars("abba");
    }

    public void testCompletion2() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
    }

    private Controller create(Shell shell) throws IOException {
        return new Controller(new TestTermIO(), shell);
    }

    private class Controller
    implements Runnable {
        private volatile boolean running = true;
        private final CountDownLatch startSync = new CountDownLatch(1);
        private final CountDownLatch stopSync = new CountDownLatch(1);
        private final Thread thread = new Thread(this);
        private final TestTermIO connector;
        private final Processor processor;

        private Controller(TestTermIO connector, Shell shell) {
            this.connector = connector;
            this.processor = new Processor((Term)new BaseTerm((TermIO)connector), shell);
        }

        public void assertStart() {
            this.thread.start();
            try {
                Assert.assertTrue((boolean)this.startSync.await(1L, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                AssertionFailedError afe = new AssertionFailedError();
                afe.initCause((Throwable)e);
                throw afe;
            }
            Assert.assertTrue((boolean)this.running);
            this.connector.assertCRLF();
            this.connector.assertChars("% ");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.running = true;
            this.startSync.countDown();
            try {
                this.processor.run();
            }
            finally {
                this.running = false;
                this.stopSync.countDown();
            }
        }

        public void assertStop() {
            Assert.assertTrue((boolean)this.running);
            this.connector.append("bye\r\n");
            this.connector.assertChars("bye");
            this.connector.assertCRLF();
        }
    }
}

