/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.processor.term;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.crsh.cmdline.CommandCompletion;
import org.crsh.cmdline.Delimiter;
import org.crsh.cmdline.spi.ValueCompletion;
import org.crsh.processor.term.ProcessContext;
import org.crsh.processor.term.Status;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.term.Term;
import org.crsh.term.TermEvent;
import org.crsh.text.CharReader;
import org.crsh.util.CloseableList;
import org.crsh.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Processor
implements Runnable {
    static final Runnable NOOP = new Runnable(){

        public void run() {
        }
    };
    final Runnable WRITE_PROMPT = new Runnable(){

        public void run() {
            Processor.this.writePrompt();
        }
    };
    final Runnable CLOSE = new Runnable(){

        public void run() {
            Processor.this.close();
        }
    };
    private final Runnable READ_TERM = new Runnable(){

        public void run() {
            Processor.this.readTerm();
        }
    };
    final Logger log = LoggerFactory.getLogger(Processor.class);
    final Term term;
    final Shell shell;
    final LinkedList<TermEvent> queue;
    final Object lock;
    ProcessContext current;
    Status status;
    volatile boolean waitingEvent;
    private final CloseableList listeners;
    private final Object termLock = new Object();
    private boolean reading = false;

    public Processor(Term term, Shell shell) {
        this.term = term;
        this.shell = shell;
        this.queue = new LinkedList();
        this.lock = new Object();
        this.status = Status.AVAILABLE;
        this.listeners = new CloseableList();
        this.waitingEvent = false;
    }

    public boolean isWaitingEvent() {
        return this.waitingEvent;
    }

    public void run() {
        try {
            String welcome = this.shell.getWelcome();
            this.log.debug("Writing welcome message to term");
            this.term.write(new CharReader(welcome));
            this.log.debug("Wrote welcome message to term");
            this.writePrompt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (true) {
            try {
                while (this.iterate()) {
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (InterruptedException e) {
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean iterate() throws InterruptedException, IOException {
        Runnable runnable;
        Object object = this.lock;
        synchronized (object) {
            switch (this.status) {
                case AVAILABLE: {
                    runnable = this.peekProcess();
                    if (runnable != null) break;
                }
                case PROCESSING: 
                case CANCELLING: {
                    runnable = this.READ_TERM;
                    break;
                }
                case CLOSED: {
                    return false;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        runnable.run();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ProcessContext peekProcess() {
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                if (this.status != Status.AVAILABLE) return null;
                if (this.queue.size() <= 0) return null;
                TermEvent event = this.queue.removeFirst();
                if (!(event instanceof TermEvent.Complete)) {
                    String line = ((Object)((TermEvent.ReadLine)event).getLine()).toString();
                    if (line.length() > 0) {
                        this.term.addToHistory(line);
                    }
                    ShellProcess process = this.shell.createProcess(line);
                    this.current = new ProcessContext(this, process);
                    this.status = Status.PROCESSING;
                    return this.current;
                }
                this.complete(((TermEvent.Complete)event).getLine());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readTerm() {
        Object object = this.termLock;
        synchronized (object) {
            if (this.reading) {
                try {
                    this.termLock.wait();
                    return;
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
            }
            this.reading = true;
        }
        try {
            Runnable runnable;
            TermEvent event = this.term.read();
            if (event instanceof TermEvent.Break) {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.queue.clear();
                    if (this.status == Status.PROCESSING) {
                        this.status = Status.CANCELLING;
                        runnable = new Runnable(){
                            ProcessContext context;
                            {
                                this.context = Processor.this.current;
                            }

                            public void run() {
                                this.context.process.cancel();
                            }
                        };
                    } else {
                        runnable = this.status == Status.AVAILABLE ? this.WRITE_PROMPT : NOOP;
                    }
                }
            }
            if (event instanceof TermEvent.Close) {
                Object object3 = this.lock;
                synchronized (object3) {
                    this.queue.clear();
                    runnable = this.status == Status.PROCESSING ? new Runnable(){
                        ProcessContext context;
                        {
                            this.context = Processor.this.current;
                        }

                        public void run() {
                            this.context.process.cancel();
                            Processor.this.close();
                        }
                    } : (this.status != Status.CLOSED ? this.CLOSE : NOOP);
                    this.status = Status.CLOSED;
                }
            }
            LinkedList<TermEvent> linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.addLast(event);
                runnable = NOOP;
            }
            runnable.run();
        }
        catch (IOException e) {
            this.log.error("Error when reading term", (Throwable)e);
        }
        finally {
            Object object4 = this.termLock;
            synchronized (object4) {
                this.reading = false;
                this.termLock.notifyAll();
            }
        }
    }

    void close() {
        this.listeners.close();
    }

    public void addListener(Closeable listener) {
        this.listeners.add(listener);
    }

    void write(CharReader reader) {
        try {
            this.term.write(reader);
        }
        catch (IOException e) {
            this.log.error("Write to term failure", (Throwable)e);
        }
    }

    void writePrompt() {
        String prompt = this.shell.getPrompt();
        try {
            String p = prompt == null ? "% " : prompt;
            CharReader cr = new CharReader().append((Object)"\r\n").append((Object)p);
            CharSequence buffer = this.term.getBuffer();
            if (buffer != null) {
                cr.append((Object)buffer);
            }
            this.term.write(cr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void complete(CharSequence prefix) {
        this.log.debug("About to get completions for " + prefix);
        CommandCompletion completion = this.shell.complete(((Object)prefix).toString());
        ValueCompletion completions = completion.getValue();
        this.log.debug("Completions for " + prefix + " are " + completions);
        Delimiter delimiter = completion.getDelimiter();
        try {
            if (completions.getSize() != 0) {
                if (completions.getSize() == 1) {
                    Map.Entry entry = (Map.Entry)completions.iterator().next();
                    Appendable buffer = this.term.getInsertBuffer();
                    String insert = (String)entry.getKey();
                    delimiter.escape((CharSequence)insert, this.term.getInsertBuffer());
                    if (((Boolean)entry.getValue()).booleanValue()) {
                        buffer.append(completion.getDelimiter().getValue());
                    }
                } else {
                    String commonCompletion = Strings.findLongestCommonPrefix(completions.getSuffixes());
                    if (commonCompletion.length() > 0) {
                        delimiter.escape((CharSequence)commonCompletion, this.term.getInsertBuffer());
                    } else {
                        int width = this.term.getWidth();
                        String completionPrefix = completions.getPrefix();
                        int max = 0;
                        for (String suffix : completions.getSuffixes()) {
                            max = Math.max(max, completionPrefix.length() + suffix.length());
                        }
                        StringBuilder sb = new StringBuilder().append('\n');
                        if ((max += 2) < width) {
                            int columns = width / max;
                            int index = 0;
                            for (String suffix : completions.getSuffixes()) {
                                sb.append(completionPrefix).append(suffix);
                                for (int l = completionPrefix.length() + suffix.length(); l < max; ++l) {
                                    sb.append(' ');
                                }
                                if (++index < columns) continue;
                                index = 0;
                                sb.append('\n');
                            }
                            if (index > 0) {
                                sb.append('\n');
                            }
                        } else {
                            Iterator i = completions.getSuffixes().iterator();
                            while (i.hasNext()) {
                                String suffix = (String)i.next();
                                sb.append(commonCompletion).append(suffix);
                                if (!i.hasNext()) continue;
                                sb.append('\n');
                            }
                            sb.append('\n');
                        }
                        this.term.write(new CharReader(sb.toString()));
                        this.writePrompt();
                    }
                }
            }
        }
        catch (IOException e) {
            this.log.error("Could not write completion", (Throwable)e);
        }
    }
}

