/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text;

import java.io.PrintWriter;
import org.crsh.text.Color;
import org.crsh.text.Decoration;
import org.crsh.text.ShellAppendable;
import org.crsh.text.Style;
import org.crsh.util.AppendableWriter;

public class ShellPrintWriter
extends PrintWriter {
    private final ShellAppendable out;

    public ShellPrintWriter(ShellAppendable out) {
        super(new AppendableWriter(out));
        this.out = out;
    }

    public final boolean isEmpty() {
        return this.out.isEmpty();
    }

    public final void print(Object obj, Color foreground) {
        this.out.append(foreground.style);
        this.print(obj);
        this.out.append(Style.reset);
    }

    public final void println(Object obj, Color foreground) {
        this.print(obj, foreground.style);
        this.println();
    }

    public final void print(Object obj, Color foreground, Color background) {
        this.out.append(Style.style(foreground, background));
        this.print(obj);
        this.out.append(Style.reset);
    }

    public final void println(Object obj, Color foreground, Color background) {
        this.print(obj, Style.style(foreground, background));
        this.println();
    }

    public final void print(Object obj, Decoration decoration) {
        this.out.append(decoration.style);
        this.print(obj);
        this.out.append(Style.reset);
    }

    public final void println(Object obj, Decoration decoration) {
        this.print(obj, decoration.style);
        this.println();
    }

    public final void print(Object obj, Decoration decoration, Color foreground) {
        this.print(obj, Style.style(decoration, foreground));
        this.println();
    }

    public final void println(Object obj, Decoration decoration, Color foreground) {
        this.print(obj, Style.style(decoration, foreground, null));
        this.println();
    }

    public final void print(Object obj, Decoration decoration, Color foreground, Color background) {
        this.print(obj, Style.style(decoration, foreground, background));
        this.println();
    }

    public final void println(Object obj, Decoration decoration, Color foreground, Color background) {
        this.print(obj, Style.style(decoration, foreground, background));
        this.println();
    }

    public final void print(Object obj, Style style) {
        this.out.append(style);
        this.print(obj);
        this.out.append(Style.reset);
    }

    public final void println(Object obj, Style style) {
        this.print(obj, style);
        this.println();
    }

    public final ShellPrintWriter leftShift(Object o) {
        if (o instanceof Style) {
            this.out.append((Style)o);
        } else if (o instanceof Decoration) {
            this.out.append(((Decoration)o).style);
        } else if (o instanceof Color) {
            this.out.append(((Color)o).style);
        } else {
            this.print(o);
        }
        return this;
    }
}

