/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.ui;

import junit.framework.TestCase;
import org.crsh.shell.TestInvocationContext;
import org.crsh.shell.io.ShellWriter;
import org.crsh.shell.ui.Element;
import org.crsh.shell.ui.LabelElement;
import org.crsh.shell.ui.RowElement;
import org.crsh.shell.ui.TableElement;
import org.crsh.shell.ui.TreeElement;
import org.crsh.text.CharReader;
import org.crsh.text.Color;
import org.crsh.text.Decoration;

public class TableElementTestCase
extends TestCase {
    public void testSimple() throws Exception {
        TableElement tableElement = new TableElement();
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("b"));
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        row2.addValue((Element)new LabelElement("c"));
        row2.addValue((Element)new LabelElement("d"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        tableElement.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)"a     b     _c     d     _", (String)reader.toString());
    }

    public void testStyle() throws Exception {
        TableElement tableElement = new TableElement();
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.setBackground(Color.green);
        row1.setForeground(Color.blue);
        row1.setDecoration(Decoration.bold);
        LabelElement a = new LabelElement("a");
        a.setParent((Element)row1);
        LabelElement b = new LabelElement("b");
        b.setParent((Element)row1);
        row1.addValue((Element)a);
        row1.addValue((Element)b);
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        LabelElement c = new LabelElement("c");
        c.setParent((Element)row2);
        c.setBackground(Color.green);
        c.setForeground(Color.blue);
        c.setDecoration(Decoration.bold);
        row2.addValue((Element)c);
        row2.addValue((Element)new LabelElement("d"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        tableElement.print(writer, new TestInvocationContext());
        String expected = "\u001b[1;34;42ma     b     \u001b[0m_\u001b[1;34;42mc     \u001b[0md     \u001b[0m_";
        StringBuilder sb = new StringBuilder();
        reader.writeAnsiTo((Appendable)sb);
        String ansi = sb.toString();
        TableElementTestCase.assertEquals((String)expected, (String)ansi);
    }

    public void testInNode() throws Exception {
        TableElement tableElement = new TableElement();
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("b"));
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        row2.addValue((Element)new LabelElement("c"));
        row2.addValue((Element)new LabelElement("d"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        TreeElement node = new TreeElement();
        node.addNode((Element)new LabelElement("foo"));
        node.addNode((Element)tableElement);
        node.addNode((Element)new LabelElement("bar"));
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        node.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)"+-foo_+-a     b     _| c     d     _+-bar_", (String)reader.toString());
    }

    public void testInNodeBorder() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.setBorder(true);
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("b"));
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        row2.addValue((Element)new LabelElement("c"));
        row2.addValue((Element)new LabelElement("d"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        TreeElement node = new TreeElement();
        node.addNode((Element)new LabelElement("foo"));
        node.addNode((Element)tableElement);
        node.addNode((Element)new LabelElement("bar"));
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        node.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)"+-foo_+- ---------------_| | a     | b     |_| | c     | d     |_|  ---------------_+-bar_", (String)reader.toString());
    }

    public void testInNodeTooLarge() throws Exception {
        TableElement tableElement = new TableElement();
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("b"));
        row1.addValue((Element)new LabelElement("c is a very very very too long value"));
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        row2.addValue((Element)new LabelElement("d"));
        row2.addValue((Element)new LabelElement("e"));
        row2.addValue((Element)new LabelElement("f"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        TreeElement node = new TreeElement();
        node.addNode((Element)new LabelElement("foo"));
        node.addNode((Element)tableElement);
        node.addNode((Element)new LabelElement("bar"));
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        node.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)"+-foo_+-a     b     c is a very very ver_|             y too long value    _| d     e     f                   _+-bar_", (String)reader.toString());
    }

    public void testInNodeTooLargeBorder() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.setBorder(true);
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("b"));
        row1.addValue((Element)new LabelElement("c is a very very very too long value"));
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        row2.addValue((Element)new LabelElement("d"));
        row2.addValue((Element)new LabelElement("e"));
        row2.addValue((Element)new LabelElement("f"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        TreeElement node = new TreeElement();
        node.addNode((Element)new LabelElement("foo"));
        node.addNode((Element)tableElement);
        node.addNode((Element)new LabelElement("bar"));
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        node.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)"+-foo_+- ------------------------------_| | a     | b     | c is a very v|_| |       |       | ery very too |_| |       |       | long value   |_| | d     | e     | f            |_|  ------------------------------_+-bar_", (String)reader.toString());
    }

    public void testInNodeHeader() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.setBorder(true);
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("b"));
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        row2.addValue((Element)new LabelElement("c"));
        row2.addValue((Element)new LabelElement("d"));
        RowElement row3 = new RowElement(true);
        row3.setParent((Element)tableElement);
        row3.addValue((Element)new LabelElement("e"));
        row3.addValue((Element)new LabelElement("f"));
        RowElement row4 = new RowElement();
        row4.setParent((Element)tableElement);
        row4.addValue((Element)new LabelElement("g"));
        row4.addValue((Element)new LabelElement("h"));
        RowElement row5 = new RowElement();
        row5.setParent((Element)tableElement);
        row5.addValue((Element)new LabelElement("i"));
        row5.addValue((Element)new LabelElement("j"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        tableElement.addRow(row3);
        tableElement.addRow(row4);
        tableElement.addRow(row5);
        TreeElement node = new TreeElement();
        node.addNode((Element)new LabelElement("foo"));
        node.addNode((Element)tableElement);
        node.addNode((Element)new LabelElement("bar"));
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        node.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)"+-foo_+- ---------------_| | a     | b     |_| | c     | d     |_|  ---------------_| | e     | f     |_|  ---------------_| | g     | h     |_| | i     | j     |_|  ---------------_+-bar_", (String)reader.toString());
    }

    public void testTooLarge() throws Exception {
        TableElement tableElement = new TableElement();
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("This text is very ver very too large to be displayed in a cell of 32"));
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        row2.addValue((Element)new LabelElement("c"));
        row2.addValue((Element)new LabelElement("d"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        tableElement.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)"a     This text is very ver very_      too large to be displayed _      in a cell of 32           _c     d                         _", (String)reader.toString());
    }

    public void testSimpleBorder() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.setBorder(true);
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("b"));
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        row2.addValue((Element)new LabelElement("c"));
        row2.addValue((Element)new LabelElement("d"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        tableElement.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)" ---------------_| a     | b     |_| c     | d     |_ ---------------_", (String)reader.toString());
    }

    public void testBorderHeaderTopBottom() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.setBorder(true);
        RowElement row1 = new RowElement(true);
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("b"));
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        row2.addValue((Element)new LabelElement("c"));
        row2.addValue((Element)new LabelElement("d"));
        RowElement row3 = new RowElement();
        row3.setParent((Element)tableElement);
        row3.addValue((Element)new LabelElement("e"));
        row3.addValue((Element)new LabelElement("f"));
        RowElement row4 = new RowElement(true);
        row4.setParent((Element)tableElement);
        row4.addValue((Element)new LabelElement("g"));
        row4.addValue((Element)new LabelElement("h"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        tableElement.addRow(row3);
        tableElement.addRow(row4);
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        tableElement.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)" ---------------_| a     | b     |_ ---------------_| c     | d     |_| e     | f     |_ ---------------_| g     | h     |_ ---------------_", (String)reader.toString());
    }

    public void testNoBorderHeaderTopBottom() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.setBorder(false);
        RowElement row1 = new RowElement(true);
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("b"));
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        row2.addValue((Element)new LabelElement("c"));
        row2.addValue((Element)new LabelElement("d"));
        RowElement row3 = new RowElement();
        row3.setParent((Element)tableElement);
        row3.addValue((Element)new LabelElement("e"));
        row3.addValue((Element)new LabelElement("f"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        tableElement.addRow(row3);
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        tableElement.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)"a     b     _c     d     _e     f     _", (String)reader.toString());
    }

    public void testBorderHeaderMiddle() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.setBorder(true);
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("b"));
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        row2.addValue((Element)new LabelElement("c"));
        row2.addValue((Element)new LabelElement("d"));
        RowElement row3 = new RowElement(true);
        row3.setParent((Element)tableElement);
        row3.addValue((Element)new LabelElement("e"));
        row3.addValue((Element)new LabelElement("f"));
        RowElement row4 = new RowElement();
        row4.setParent((Element)tableElement);
        row4.addValue((Element)new LabelElement("g"));
        row4.addValue((Element)new LabelElement("h"));
        RowElement row5 = new RowElement();
        row5.setParent((Element)tableElement);
        row5.addValue((Element)new LabelElement("i"));
        row5.addValue((Element)new LabelElement("j"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        tableElement.addRow(row3);
        tableElement.addRow(row4);
        tableElement.addRow(row5);
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        tableElement.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)" ---------------_| a     | b     |_| c     | d     |_ ---------------_| e     | f     |_ ---------------_| g     | h     |_| i     | j     |_ ---------------_", (String)reader.toString());
    }

    public void testBorderHeaderTwoMiddle() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.setBorder(true);
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("b"));
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        row2.addValue((Element)new LabelElement("c"));
        row2.addValue((Element)new LabelElement("d"));
        RowElement row3 = new RowElement(true);
        row3.setParent((Element)tableElement);
        row3.addValue((Element)new LabelElement("e"));
        row3.addValue((Element)new LabelElement("f"));
        RowElement row4 = new RowElement(true);
        row4.setParent((Element)tableElement);
        row4.addValue((Element)new LabelElement("g"));
        row4.addValue((Element)new LabelElement("h"));
        RowElement row5 = new RowElement();
        row5.setParent((Element)tableElement);
        row5.addValue((Element)new LabelElement("i"));
        row5.addValue((Element)new LabelElement("j"));
        RowElement row6 = new RowElement();
        row6.setParent((Element)tableElement);
        row6.addValue((Element)new LabelElement("k"));
        row6.addValue((Element)new LabelElement("l"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        tableElement.addRow(row3);
        tableElement.addRow(row4);
        tableElement.addRow(row5);
        tableElement.addRow(row6);
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        tableElement.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)" ---------------_| a     | b     |_| c     | d     |_ ---------------_| e     | f     |_ ---------------_| g     | h     |_ ---------------_| i     | j     |_| k     | l     |_ ---------------_", (String)reader.toString());
    }

    public void testTooLargeBorder() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.setBorder(true);
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("This text is very ver very too large to be displayed in a cell of 32"));
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        row2.addValue((Element)new LabelElement("c"));
        row2.addValue((Element)new LabelElement("d"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        tableElement.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)" ------------------------------_| a     | This text is very ver|_|       | very too large to be |_|       | displayed in a cell o|_|       | f 32                 |_| c     | d                    |_ ------------------------------_", (String)reader.toString());
    }

    public void testTooLargeBorderHeader() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.setBorder(true);
        RowElement row1 = new RowElement(true);
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("This text is very ver very too large to be displayed in a cell of 32"));
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        row2.addValue((Element)new LabelElement("c"));
        row2.addValue((Element)new LabelElement("d"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        tableElement.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)" ------------------------------_| a     | This text is very ver|_|       | very too large to be |_|       | displayed in a cell o|_|       | f 32                 |_ ------------------------------_| c     | d                    |_ ------------------------------_", (String)reader.toString());
    }

    public void testBorderStyle() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.setBorder(true);
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.setBackground(Color.green);
        row1.setForeground(Color.blue);
        row1.setDecoration(Decoration.bold);
        LabelElement a = new LabelElement("a");
        a.setParent((Element)row1);
        LabelElement b = new LabelElement("b");
        b.setParent((Element)row1);
        row1.addValue((Element)a);
        row1.addValue((Element)b);
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        LabelElement c = new LabelElement("c");
        c.setParent((Element)row2);
        c.setBackground(Color.green);
        c.setForeground(Color.blue);
        c.setDecoration(Decoration.bold);
        row2.addValue((Element)c);
        row2.addValue((Element)new LabelElement("d"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        tableElement.print(writer, new TestInvocationContext());
        String expected = " ---------------_|\u001b[1;34;42m a     \u001b[0m|\u001b[1;34;42m b     \u001b[0m|_|\u001b[1;34;42m c     \u001b[0m| \u001b[0md     \u001b[0m|_ ---------------_";
        StringBuilder sb = new StringBuilder();
        reader.writeAnsiTo((Appendable)sb);
        String ansi = sb.toString();
        TableElementTestCase.assertEquals((String)expected, (String)ansi);
    }

    public void testTooManyColumns() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.setBorder(true);
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("This text is very ver very too large to be displayed in a cell of 32"));
        row1.addValue((Element)new LabelElement("b"));
        tableElement.addRow(row1);
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        tableElement.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)" ------------------------------_| a     | This text is very ver|_|       | very too large to be |_|       | displayed in a cell o|_|       | f 32                 |_ ------------------------------_", (String)reader.toString());
    }
}

