/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text;

import java.util.List;
import org.crsh.AbstractTestCase;
import org.crsh.text.CharReader;
import org.crsh.text.Color;
import org.crsh.text.Decoration;
import org.crsh.text.Style;
import org.crsh.util.Utils;

public class CharReaderTestCase
extends AbstractTestCase {
    private static final Style RED = Style.style(null, null, (Color)Color.red);
    private static final Style BLUE = Style.style(null, null, (Color)Color.blue);
    private static final Style UNDERLINE = Style.style((Decoration)Decoration.underline, null, null);
    private static final Style RED_UNDERLINE = Style.style((Decoration)Decoration.underline, null, (Color)Color.red);

    public void testSimple() {
        this.assertReader(new CharReader().append((Object)"a"), "a");
        this.assertReader(new CharReader().append(new Object[]{RED, "a"}), RED, "a");
    }

    public void testMergeCharSequence() {
        this.assertReader(new CharReader().append((Object)"a").append((Object)"b"), "ab");
    }

    public void testMergeColor() {
        this.assertReader(new CharReader().append(new Object[]{RED, "a", RED, "b"}), RED, "ab");
    }

    public void testOverwriteColor() {
        this.assertReader(new CharReader().append(new Object[]{BLUE, RED, "a"}), RED, "a");
    }

    public void testOverwriteMergeColor() {
        this.assertReader(new CharReader().append(new Object[]{RED, "a", BLUE, RED, "b"}), RED, "ab");
    }

    public void testLastColor() {
        this.assertReader(new CharReader().append(new Object[]{RED, "a", BLUE}), RED, "a", BLUE);
    }

    public void testBlendStyle() {
        this.assertReader(new CharReader().append(new Object[]{RED, UNDERLINE, "a"}), RED_UNDERLINE, "a");
    }

    public void testConcatenation() {
        this.assertReader(new CharReader().append((Object)RED).append((Object)new CharReader().append((Object)"a")), RED, "a");
        this.assertReader(new CharReader().append((Object)new CharReader().append((Object)RED)).append((Object)"a"), RED, "a");
    }

    private void assertReader(CharReader reader, Object ... expected) {
        List res = Utils.list((Iterable)reader);
        CharReaderTestCase.assertEquals((int)expected.length, (int)res.size());
        for (int i = 0; i < expected.length; ++i) {
            CharReaderTestCase.assertEquals((String)expected[i].toString(), (String)res.get(i).toString());
        }
    }
}

