/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.crsh.util.AppendableWriter;

public class AppendableWriterTestCase
extends TestCase {
    public void testWrite() throws IOException {
        StringBuilder buffer = new StringBuilder();
        AppendableWriter writer = new AppendableWriter((Appendable)buffer);
        writer.write("foo");
        AppendableWriterTestCase.assertEquals((String)"foo", (String)buffer.toString());
        buffer.setLength(0);
        writer.write(97);
        AppendableWriterTestCase.assertEquals((String)"a", (String)buffer.toString());
        buffer.setLength(0);
        writer.write("bar".toCharArray(), 0, 1);
        AppendableWriterTestCase.assertEquals((String)"b", (String)buffer.toString());
        buffer.setLength(0);
    }

    public void testClose() throws IOException {
        StringBuilder buffer = new StringBuilder();
        AppendableWriter writer = new AppendableWriter((Appendable)buffer);
        writer.close();
        try {
            writer.write("foo");
            AppendableWriterTestCase.fail();
        }
        catch (IOException expected) {
            AppendableWriterTestCase.assertEquals((String)"", (String)buffer.toString());
        }
        writer.close();
        try {
            writer.flush();
            AppendableWriterTestCase.fail();
        }
        catch (IOException expected) {
            AppendableWriterTestCase.assertEquals((String)"", (String)buffer.toString());
        }
        writer.close();
    }

    public void testPropagateClose() throws IOException {
        final AtomicInteger closed = new AtomicInteger();
        StringWriter buffer = new StringWriter(){

            public void close() throws IOException {
                closed.incrementAndGet();
                super.close();
            }
        };
        AppendableWriter writer = new AppendableWriter((Appendable)buffer);
        AppendableWriterTestCase.assertEquals((int)0, (int)closed.get());
        writer.close();
        AppendableWriterTestCase.assertEquals((int)1, (int)closed.get());
        writer.close();
        AppendableWriterTestCase.assertEquals((int)1, (int)closed.get());
    }

    public void testIOException() throws IOException {
        final IOException ioe1 = new IOException();
        Writer buffer = new Writer(){

            public void write(char[] cbuf, int off, int len) throws IOException {
                throw ioe1;
            }

            public void flush() throws IOException {
            }

            public void close() throws IOException {
            }
        };
        AppendableWriter writer = new AppendableWriter((Appendable)buffer);
        try {
            writer.write("foo");
            AppendableWriterTestCase.fail();
        }
        catch (IOException e) {
            AppendableWriterTestCase.assertSame((Object)ioe1, (Object)e);
        }
        final IOException ioe2 = new IOException();
        final AtomicInteger count = new AtomicInteger();
        buffer = new Writer(){

            public void write(char[] cbuf, int off, int len) throws IOException {
            }

            public void flush() throws IOException {
            }

            public void close() throws IOException {
                count.incrementAndGet();
                if (count.get() == 1) {
                    throw ioe2;
                }
            }
        };
        writer = new AppendableWriter((Appendable)buffer);
        AppendableWriterTestCase.assertEquals((int)0, (int)count.get());
        try {
            writer.close();
            AppendableWriterTestCase.fail();
        }
        catch (IOException e) {
            AppendableWriterTestCase.assertEquals((int)1, (int)count.get());
            AppendableWriterTestCase.assertSame((Object)ioe2, (Object)e);
        }
        writer.close();
        AppendableWriterTestCase.assertEquals((int)1, (int)count.get());
    }
}

