/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.crsh.shell.io.ShellWriter;
import org.crsh.shell.ui.Element;
import org.crsh.shell.ui.Pad;
import org.crsh.shell.ui.TableElement;
import org.crsh.shell.ui.UIWriterContext;
import org.crsh.text.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowElement
extends Element {
    private List<Element> cols = new ArrayList<Element>();
    boolean header;

    public RowElement() {
    }

    public RowElement(boolean header) {
        this();
        this.header = header;
    }

    @Override
    public void print(UIWriterContext ctx, ShellWriter writer) throws IOException {
        this.doPrint(ctx, writer);
    }

    @Override
    void doPrint(UIWriterContext ctx, ShellWriter writer) throws IOException {
        int i = 0;
        TableElement table = (TableElement)this.getParent();
        List<Integer> colsSize = table.getColsSize();
        if (table.border && this.header) {
            ctx.needLine = this.header;
        }
        if (table.border) {
            ctx.leftLinePadding = ctx.leftLinePadding + "| ";
            ctx.rightLinePadding = ctx.rightLinePadding + "|";
        }
        for (Element e : this.cols) {
            int availableWidth = ctx.getConsoleWidth() - ctx.leftLinePadding.length() - ctx.rightLinePadding.length();
            if (availableWidth <= 0) break;
            ctx.pad(writer);
            if (ctx.needLF) {
                if (table.border) {
                    writer.append("|");
                }
                writer.append("\n");
                ctx.parentUIContext.pad(writer);
                if (table.border && ctx.needLine) {
                    ctx.printLine(table.width() - 2, writer);
                    ctx.parentUIContext.pad(writer);
                }
            }
            ctx.padStyle = null;
            if (table.border) {
                writer.append("|");
                ctx.stack.add(Pad.SPACE);
                ctx.padStyle = Style.style(e.getDecoration(), e.getForeground(), e.getBackground());
                ctx.pad(writer);
            }
            e.print(ctx, writer);
            ctx.stack.clear();
            ctx.padStyle = Style.style(e.getDecoration(), e.getForeground(), e.getBackground());
            for (int j = 0; j < colsSize.get(i) - e.width(); ++j) {
                ctx.stack.add(Pad.SPACE);
            }
            for (int index = 0; index < table.getColsSize().get(i); ++index) {
                ctx.leftLinePadding = ctx.leftLinePadding + " ";
            }
            if (table.border) {
                ctx.leftLinePadding = ctx.leftLinePadding + "| ";
            }
            ++i;
            ctx.needLF = false;
            ctx.needLine = false;
        }
        ctx.needLF = true;
        ctx.needLine = this.header;
        ctx.leftLinePadding = "";
        ctx.rightLinePadding = "";
    }

    @Override
    int width() {
        return 0;
    }

    public void addValue(Element element) {
        this.cols.add(element);
    }

    public List<Element> getValues() {
        return this.cols;
    }
}

