/*
 * Decompiled with CFR 0.152.
 */
package org.crsh;

import java.sql.SQLException;
import org.crsh.command.ScriptException;
import org.crsh.shell.AbstractCommandTestCase;

public class JDBCCommandTestCase
extends AbstractCommandTestCase {
    public void testCannotConnect() {
        this.assertEvalError("jdbc connect jdbc:foo", SQLException.class);
    }

    public void testNotConnected() {
        this.assertEvalError("jdbc execute create table derbyDB(num int, addr varchar(40))", ScriptException.class);
    }

    public void testExecute() {
        System.setProperty("derby.connection.requireAuthentication", "true");
        System.setProperty("derby.authentication.provider", "BUILTIN");
        System.setProperty("derby.user.my_user", "my_password");
        this.assertOk("jdbc connect -u my_user -p my_password jdbc:derby:memory:EmbeddedDB;create=true");
        this.assertOk("jdbc execute create table derbyDB(num int, addr varchar(40))");
        this.assertOk("jdbc execute insert into derbyDB values (1956,'Webster St.')");
        String res = this.assertOk("jdbc select * from derbyDb");
        JDBCCommandTestCase.assertTrue((String)("Was expecting " + res + " to contain 'Webster'"), (boolean)res.contains("Webster"));
        this.lifeCycle.setCommand("foo", "jdbc.select '* from derbyDb', { Map it -> out << it['NUM'] }");
        JDBCCommandTestCase.assertEquals((String)"1956", (String)this.assertOk("foo"));
        this.assertOk("jdbc close");
    }

    public void testClose() {
        this.assertEvalError("jdbc close", ScriptException.class);
    }
}

