/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import java.util.Arrays;
import junit.framework.TestCase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.crsh.command.GroovyScriptCommand;
import org.crsh.command.ShellCommand;
import org.crsh.command.SyntaxException;
import org.crsh.shell.TestInvocationContext;

public class InvocationContextTestCase
extends TestCase {
    private GroovyClassLoader loader;
    private GroovyShell shell;

    protected void setUp() throws Exception {
        CompilerConfiguration config = new CompilerConfiguration();
        config.setScriptBaseClass(GroovyScriptCommand.class.getName());
        this.loader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader(), config);
        this.shell = new GroovyShell((ClassLoader)this.loader);
    }

    public void testOut() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.CRaSHCommand { @Command\npublic void main() {out.print(\"abc\");}}");
        ShellCommand command = (ShellCommand)clazz.newInstance();
        InvocationContextTestCase.assertEquals((String)"abc", (String)new TestInvocationContext().execute(command, new String[0]));
    }

    public void testOptionInjectionInCommandClassCmdLine() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.CRaSHCommand { @Option(names=\"s\") @Required def String str = 'default value';@Command\npublic Object main() {return str;}}");
        ShellCommand command = (ShellCommand)clazz.newInstance();
        InvocationContextTestCase.assertEquals((String)"abc", (String)new TestInvocationContext().execute(command, "-s", "abc"));
        try {
            new TestInvocationContext().execute(command, new String[0]);
            InvocationContextTestCase.fail();
        }
        catch (SyntaxException syntaxException) {
            // empty catch block
        }
    }

    public void testContextAccessFromCommandClassCmdLine() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.CRaSHCommand { @Command\npublic Object main() {return juu;}}");
        ShellCommand cmd = (ShellCommand)clazz.newInstance();
        TestInvocationContext ctx = new TestInvocationContext();
        ctx.getSession().put("juu", "daa");
        InvocationContextTestCase.assertEquals((String)"daa", (String)ctx.execute(cmd, new String[0]));
    }

    public void testArgumentInjectionInCommandCmdLine() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.CRaSHCommand { @Command\npublic Object main(@Argument String str) {return str;}}");
        ShellCommand cmd = (ShellCommand)clazz.newInstance();
        InvocationContextTestCase.assertEquals((String)"b", (String)new TestInvocationContext().execute(cmd, "b"));
    }

    public void testMainInCommandCmdLine() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.CRaSHCommand { @Command\npublic Object main() {return 'foo';}}");
        ShellCommand cmd = (ShellCommand)clazz.newInstance();
        InvocationContextTestCase.assertEquals((String)"foo", (String)new TestInvocationContext().execute(cmd, new String[0]));
    }

    public void testContextAccessInCommandClass() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.CRaSHCommand { @Command\npublic Object main() {return bar;}}");
        TestInvocationContext ctx = new TestInvocationContext();
        ctx.getSession().put("bar", "bar_value");
        ShellCommand cmd = (ShellCommand)clazz.newInstance();
        InvocationContextTestCase.assertEquals((String)"bar_value", (String)ctx.execute(cmd, new String[0]));
    }

    public void testClosureInvocationInClass() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.CRaSHCommand { @Command\npublic Object main() {return bar();}}");
        TestInvocationContext ctx = new TestInvocationContext();
        Closure closure = (Closure)this.shell.evaluate("{ -> return 'from_closure'; }");
        ctx.getSession().put("bar", closure);
        ShellCommand cmd = (ShellCommand)clazz.newInstance();
        InvocationContextTestCase.assertEquals((String)"from_closure", (String)ctx.execute(cmd, new String[0]));
    }

    public void testArgumentQuoteInClass() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic Object main(@org.crsh.cmdline.annotations.Argument List<String> arguments) {\nreturn arguments;\n}\n}\n");
        ShellCommand cmd = (ShellCommand)clazz.newInstance();
        InvocationContextTestCase.assertEquals((String)("" + Arrays.asList("foo")), (String)new TestInvocationContext().execute(cmd, "'foo'"));
    }

    public void testArgumentQuoteInClass2() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic Object main(@org.crsh.cmdline.annotations.Argument(unquote = false) List<String> arguments) {\nreturn arguments;\n}\n}\n");
        ShellCommand cmd = (ShellCommand)clazz.newInstance();
        InvocationContextTestCase.assertEquals((String)("" + Arrays.asList("'foo'")), (String)new TestInvocationContext().execute(cmd, "'foo'"));
    }

    public void testContextAccessInScript() throws Exception {
        Class clazz = this.loader.parseClass("System.out.println('bar:' + bar) ; return bar;");
        ShellCommand script = (ShellCommand)clazz.newInstance();
        TestInvocationContext ctx = new TestInvocationContext();
        ctx.getSession().put("bar", "bar_value");
        InvocationContextTestCase.assertEquals((String)"bar_value", (String)ctx.execute(script, new String[0]));
    }

    public void testArgumentAccessInScript() throws Exception {
        Class clazz = this.loader.parseClass("return args[0];");
        ShellCommand script = (ShellCommand)clazz.newInstance();
        InvocationContextTestCase.assertEquals((String)"arg_value", (String)new TestInvocationContext().execute(script, "arg_value"));
    }

    public void testArgumentAccessInClosure() throws Exception {
        Class clazz = this.loader.parseClass("{ arg -> return arg };");
        ShellCommand script = (ShellCommand)clazz.newInstance();
        InvocationContextTestCase.assertEquals((String)"arg_value", (String)new TestInvocationContext().execute(script, "arg_value"));
    }

    public void testResolveContext() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic Object main() {\nreturn context.class.name;\n}\n}\n");
        ShellCommand cmd = (ShellCommand)clazz.newInstance();
        TestInvocationContext context = new TestInvocationContext();
        InvocationContextTestCase.assertEquals((String)((Object)((Object)context)).getClass().getName(), (String)context.execute(cmd, new String[0]));
    }

    public void testResolveContextInScript() throws Exception {
        Class clazz = this.loader.parseClass("return context.class.name");
        ShellCommand cmd = (ShellCommand)clazz.newInstance();
        TestInvocationContext context = new TestInvocationContext();
        InvocationContextTestCase.assertEquals((String)((Object)((Object)context)).getClass().getName(), (String)context.execute(cmd, new String[0]));
    }

    public void testScriptUseReturnValue() throws Exception {
        Class clazz = this.loader.parseClass("return 'def'");
        ShellCommand script = (ShellCommand)clazz.newInstance();
        InvocationContextTestCase.assertEquals((String)"def", (String)new TestInvocationContext().execute(script, new String[0]));
    }

    public void testScriptDiscardReturnValue() throws Exception {
        Class clazz = this.loader.parseClass("out << 'abc'\nreturn 'def'");
        ShellCommand script = (ShellCommand)clazz.newInstance();
        InvocationContextTestCase.assertEquals((String)"abc", (String)new TestInvocationContext().execute(script, new String[0]));
    }
}

