/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.processor.term;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import org.crsh.AbstractTestCase;
import org.crsh.term.Term;
import org.crsh.term.TermEvent;
import org.crsh.text.Chunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncTerm
implements Term {
    private final LinkedList<Throwable> failures = new LinkedList();
    private final LinkedList<Callable<TermEvent>> queue = new LinkedList();
    private final Object lock = new Object();
    private boolean closed = false;

    public void publish(final TermEvent event) {
        this.publish(new Callable<TermEvent>(){

            @Override
            public TermEvent call() throws Exception {
                return event;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Callable<TermEvent> event) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw AbstractTestCase.failure("closed");
            }
            this.queue.addLast(event);
            this.lock.notifyAll();
        }
    }

    public int getWidth() {
        return 32;
    }

    public int getHeight() {
        return 40;
    }

    public String getProperty(String name) {
        return null;
    }

    public void setEcho(boolean echo) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TermEvent read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.closed) {
                if (this.queue.size() > 0) {
                    try {
                        Callable<TermEvent> callable = this.queue.removeFirst();
                        return callable.call();
                    }
                    catch (Exception e) {
                        if (e instanceof IOException) {
                            throw (IOException)e;
                        }
                        throw new UndeclaredThrowableException(e);
                    }
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
            return TermEvent.close();
        }
    }

    public Class<Chunk> getConsumedType() {
        return Chunk.class;
    }

    public void provide(Chunk element) throws IOException {
    }

    public Appendable getInsertBuffer() {
        return null;
    }

    public CharSequence getBuffer() {
        return null;
    }

    public void addToHistory(CharSequence line) {
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                this.lock.notifyAll();
            }
        }
    }
}

